<?php
/**
 * @package 	customfilters
 * @author		Sakis Terz
 * @copyright	Copyright (c) 2012-2022 breakdesigns.net. All rights reserved.
 * @license		http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Breakdesigns\Customfilters\Admin\Model\UpdateManager;

/**
 * main controller class
 * @package        customfilters
 * @since        1.0
 */
class CustomfiltersController extends JControllerLegacy
{

    /**
     * Method to display a view.
     *
     * @param bool $cachable
     * @param bool $urlparams
     * @return $this|JControllerLegacy
     * @throws Exception
     * @since 1.0
     */
    public function display($cachable = false, $urlparams = false)
    {
        $input = Factory::getApplication()->input;
        $view = $input->get('view', 'customfilters', '');
        if ($view == 'customfilters' || $view == '') {
            $this->_createFilters();
            UpdateManager::getInstance()->refreshUpdateSite();
        }

        $this->systemCheck();

        parent::display();
        return $this;
    }

    /**
     * Check if all the requirements are met and print the necessary messages.
     *
     * @since 2.12.0
     */
    protected function systemCheck()
    {
        if (version_compare(JVERSION, '3.8.1', 'lt')) {
            Factory::getApplication()->enqueueMessage(Text::_('COM_CUSTOMFILTERS_UPDATE_JOOMLA_VERSION'),
                'error');
        }

        $needsdlid = UpdateManager::getInstance()->needsDownloadID();

        if ($needsdlid) {
            Factory::getApplication()->enqueueMessage(Text::sprintf('COM_CUSTOMFILTERS_NEEDS_DLD',
                'https://breakdesigns.net/custom-filters-manual-pro/49-using-the-live-update-49'),
                'warning');
        }
    }

    /**
     *  Function to load the existing custom fields to the filters table
     *
     * @throws Exception
     * @since 1.0
     */
    protected function _createFilters()
    {
        $model = $this->getModel();
        try {
            $model->createFilters();
        } catch (\Exception $exception) {
            throw $exception;
        }
    }

    /**
     * Function to get version info
     *
     * @since 1.0
     */
    public function getVersionInfo()
    {
        $html_result = UpdateManager::getInstance()->getVersionInfo();
        if ($html_result) {
            echo json_encode($html_result);
        }
        else {
            echo '';
        }
        jexit();
    }
}
