<?php
/**
 *
 * The optimizer controller file
 *
 * @package        customfilters
 * @copyright      Copyright (c) 2012-2022 breakdesigns.net. All rights reserved.
 * @license        http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *                customfilters is free software. This version may have been modified
 *                pursuant to the GNU General Public License, and as distributed
 *                it includes or is derivative of works licensed under the GNU
 *                General Public License or other free or open source software
 *                licenses.
 * @author         Sakis Terz
 * @link           http://breakdesigns.net
 * @version        $Id: controller.php 2014-03-06 19:09:00Z sakis $
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Session\Session;

/**
 * Optimizer controller class
 * @package        customfilters
 * @since          1.0
 * @author         Sakis Terz
 */
class CustomfiltersControllerOptimizer extends BaseController
{

    /**
     * Triggers the optimization functions in the model.
     *
     * @return string json containing the log
     * @since 1.9.5
     */
    public function optimize()
    {
        if (!Session::checkToken('post')) {
            echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);
        }
        else {
            /** @var CustomfiltersModelOptimizer $model */
            $model = $this->getModel();
            $log = $model->optimize();
            echo json_encode($log);
        }
    }

    /**
     * Proxy for getModel.
     *
     * @param   string  $name  The name of the model.
     * @param   string  $prefix  The prefix for the PHP class name.
     *
     * @return    JModel
     * @since    1.0
     */
    public function getModel(
        $name = 'Optimizer',
        $prefix = 'CustomfiltersModel',
        $config = array('ignore_request' => true)
    ) {
        $model = parent::getModel($name, $prefix, $config);

        return $model;
    }
}
