/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
(function($) {
	'use strict';

	var methods = {
		init: function(options) {
			return this.each(function() {
				this.self = $(this);
				this.opt = $.extend(true, {}, $.fn.simpleGallery.defaults, options);
				methods._initialize.call(this);
				methods._update.call(this);

			});
		},

		_initialize: function() {
			var that = this;
			this.main = $(this.self.data('main'));
			this.mainLink = this.main.parent('a');
			if (!this.mainLink.length) {
				this.mainLink = this.main;
			}
			if (!this.mainLink.parent('.vpf-simplegallery-main-cont').length) {
				this.mainLink.wrap('<div class="vpf-simplegallery-main-cont"/>');
			}
			this.parent = this.mainLink.parent('.vpf-simplegallery-main-cont');
			this.sync = $(this.self.data('sync'));
			this.container = $(this.self.data('cont'));
			this.src = this.self.attr('href');
			if (!this.mainLink.length || !this.sync) {
				return;
			}
			this.main.on('click', function(e) {
				e.preventDefault();
				$('a.active', that.sync).click();
				return false;
			});
		},

		_update: function() {
			var that = this;

			that.self.on('click', function() {
				if (!that.main.length || !that.src) {
					return;
				}
				if (this.main.attr('src') == that.src) {
					return false;
				}
				methods._showLoader.call(that);
				that.container.find('.image-thumb').removeClass('active');
				$(this).parent('.image-thumb').addClass('active');
				$('[data-key="' + $(this).data('key') + '"]', that.sync).addClass('active').siblings().removeClass('active');
				this.image = $('<img />')
					.on('load', function() {
						if ($('.vpf-simplegallery-error', that.parent).length) {
							$('.vpf-simplegallery-error', that.parent).remove();
						}
						that.main.attr('src', that.src).stop(true, true).hide().fadeIn(200);
						methods._removeLoader.call(that);
					})
					.attr('src', that.src)
					.on('error', function() {
						methods._removeLoader.call(that);
						methods._showError.call(that);
					}).each(function() {
						if (this.complete) {
							$(this).trigger('load');
						}
					});

				return false;
			});
		},

		_showLoader: function() {
			var that = this;
			this.loading = setTimeout(function() {
				if (!$('.vpf-simplegallery-loading', that.parent).length) {
					that.parent.append('<div class="vpf-simplegallery-loading"></div>').find(':last').stop(true, true).hide().fadeIn(100);
				}
			}, 200);
		},

		_removeLoader: function() {
			var that = this;
			clearTimeout(this.loading);
			$('.vpf-simplegallery-loading', this.parent).remove();
		},

		_showError: function() {
			if ($('.vpf-simplegallery-error', this.parent).length) {
				$('.vpf-simplegallery-error', this.parent).remove();
			}
			this.parent.append('<div class="vpf-simplegallery-error"></div>').find(':last').stop(true, true).hide().fadeIn(100);
		}

	};

	$.fn.simpleGallery = function(method) {
		if (methods[method]) {
			return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if (typeof method === 'object' || !method) {
			return methods.init.apply(this, arguments);
		} else {
			$.error('Method ' + method + ' does not exist in jQuery.simpleGallery!');
		}
	};

	$.fn.simpleGallery.defaults = {

	};

	$(document).ready(function() {
		$('.vpf-simplegallery-item').simpleGallery();
	});

})(jQuery);