/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
if (typeof VPFramework === 'undefined' || typeof VPFramework === undefined) {
	var jQ = jQuery.noConflict();

	var VPFramework = {
		submitform: function(task, form) {
			var $form = jQ(form);
			var $saveBtn = jQ('#vpf-toolbar button .aicon-floppy-disk2');
			if (!form || !$form) {
				alert('VPFramework.submitform(task, form): Form is undefined');
				return;
			}
			jQ('input[name="task"]', $form).val(task);

			jQ.ajax({
				type: $form.attr('method'),
				dataType: 'json',
				url: $form.attr('action'),
				data: $form.serialize(),
				cache: false,
				beforeSend: function() {
					$saveBtn.removeClass('aicon-floppy-disk2').addClass('aicon-spinner aicon-spin');
				},
				success: function(data) {
					$saveBtn.removeClass('aicon-spinner aicon-spin').addClass('aicon-floppy-disk2');
					jQ('input[name="task"]', $form).val('');
					var type = 'green';
					if (data.error) {
						type = 'red';
					} else if (!jQ('input.vp-new-theme-field').hasClass('hide')) {
						data.msg = data.msg ? data.msg + '<br/>Please wait as the page gets reloaded.' : 'Please wait as the page gets reloaded.';
						data.reload = true;
					}
					if (data.msg) {
						VPFramework.showMessage(data.msg, type);
					}
					if (data.redirect) {
						setTimeout(function() {
							window.location.replace(data.redirect);
						}, 100);
					} else if (data.reload) {
						setTimeout(function() {
							window.location.reload();
						}, 100);
					}
					if (jQ('#vp-site-preview').length) {
						jQ('#vp-preview-wrap .loading').removeClass('hide');
						jQ('#vp-site-preview')[0].contentDocument.location.reload(true);
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					jQ('input[name="task"]', $form).val('');
					$saveBtn.removeClass('aicon-spinner aicon-spin').addClass('aicon-floppy-disk2');
					VPFramework.showMessage(textStatus, 'red');
					console.log(jqXHR);
					console.log(textStatus);
					console.log(errorThrown);
				}
			});
			return true;
		},
		reloadLESSFields: function(select) {
			var theme = jQ(select).val();
			var $form = jQ('form#style-form');
			jQ('#vpLessFields .loading').removeClass('hide');
			jQ.ajax({
				type: 'GET',
				dataType: 'JSON',
				url: $form.attr('action'),
				cache: false,
				data: '&task=style.getLESSFieldsAjax&theme=' + theme + '&' + window.jtoken + '=1',
				success: function(e) {
					jQ('#vpLessFields .loading').addClass('hide');
					if (!e.error && e.msg) {
						jQ('#vpLessFields').html(e.msg);
						jQ('#vpLessFields .hasTooltip').tooltip({
							"html": true,
							"container": "body"
						});
						jQ('#vpLessFields .minicolors').each(function() {
							jQ(this).minicolors({
								control: jQ(this).attr('data-control') || 'hue',
								position: jQ(this).attr('data-position') || 'right',
								theme: 'bootstrap'
							});
						});
						jQ('#vpLessFields select').chosen({
							"disable_search_threshold": 10,
							"allow_single_deselect": true,
							"placeholder_text_multiple": "Select some options",
							"placeholder_text_single": "Select an option",
							"no_results_text": "No results match"
						});
					} else if (e.error) {
						if (e.msg && jQ.type(e.msg) === "string") {
							VPFramework.showMessage(e.msg, 'red');
						}
					}
					if (e.redirect) {
						window.location.replace(e.redirect);
					} else if (e.reload) {
						window.location.reload();
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(jqXHR);
					console.log(textStatus);
					console.log(errorThrown);
					jQ('#vpLessFields .loading').addClass('hide');
					VPFramework.showMessage(textStatus, 'red');
				}
			});
		},
		verifyFiles: function() {
			var $form = jQ('form#style-form');
			var areaWidth = jQ('#vp-file-verification').width();
			jQ.ajax({
				type: 'GET',
				dataType: 'JSON',
				url: $form.attr('action'),
				cache: false,
				data: '&task=style.getFilesIntegrity&' + window.jtoken + '=1',
				success: function(e) {
					var foundChanges = false;
					if (!e.error && e.msg && jQ.isPlainObject(e.msg)) {
						jQ.each(e.msg, function(key, value) {
							if (value && jQ('.' + key).length) {
								jQ('.' + key).html(value);
								jQ('.' + key).removeClass('hide');
								jQ('.' + key).parent().removeClass('hide');
								foundChanges = true;
							}
						});
						jQ('#vp-file-verification .success').removeClass('hide');
						jQ('#vp-file-verification .running, #vp-file-verification .failed').addClass('hide');
						if (foundChanges) {
							jQ('#vp-file-verification .success .foundChanges').removeClass('hide');
						} else {
							jQ('#vp-file-verification .success .foundNoChange').removeClass('hide');
						}
						jQ('#vp-file-verification pre').width(areaWidth);
					} else if (e.error) {
						if (e.msg && jQ.type(e.msg) === "string") {
							jQ('#vp-file-verification .failed').html(e.msg);
						}
						jQ('#vp-file-verification .failed').removeClass('hide');
						jQ('#vp-file-verification .running, #vp-file-verification .success').addClass('hide');
					}
					if (e.redirect) {
						window.location.replace(e.redirect);
					} else if (e.reload) {
						window.location.reload();
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.log(jqXHR);
					console.log(textStatus);
					console.log(errorThrown);
					jQ('#vp-file-verification .failed').removeClass('hide');
					jQ('#vp-file-verification .running, #vp-file-verification .success').addClass('hide');
				}
			});
		},
		getLatestVersion: function() {
			if (jQ('[data-action="getversion"]').length) {
				jQ('[data-action="getversion"]').each(function() {
					var $that = jQ(this);
					var extension_id = $that.data('extensionid');
					var installed_version = $that.data('currentversion');
					var $form = jQ('form#style-form');

					jQ.ajax({
						type: 'GET',
						dataType: 'JSON',
						cache: false,
						url: $form.attr('action') + '&' + window.jtoken + '=1',
						data: {
							task: 'style.findUpdate',
							extension_id: extension_id,
							installed_version: installed_version
						},
						success: function(e) {
							var foundChanges = false;
							if (!e.error && e.msg && jQ.isPlainObject(e.msg)) {
								$that.html(e.msg.version);
								if (e.msg.updateFound) {
									jQ('#vp-versions .present-version[data-extensionid="' + extension_id + '"]').addClass('label-important');
									jQ('#vp-versions .found').removeClass('hide');
									var $dlk = jQ('input[data-vpdk="validate"]');
									if (!$dlk.val() || $dlk.val() == '' || $dlk.data('vpdkaccess') == '0') {
										jQ('[data-update="nodlk"]').removeClass('hide');
									} else {
										jQ('[data-update="btn"]').removeAttr('disabled');
									}
									if (e.msg.infourl) {
										jQ('[data-update="infourl"]').attr('href', e.msg.infourl).removeClass('hide');
									}
								} else {
									jQ('#vp-versions .present-version[data-extensionid="' + extension_id + '"]').addClass('label-success');
								}
							} else if (e.error) {
								if (e.msg && jQ.type(e.msg) === "string") {
									jQ('#vp-get-version .failed').html(e.msg);
								}
								$that.html('');
							}
							if (e.redirect) {
								window.location.replace(e.redirect);
							} else if (e.reload) {
								window.location.reload();
							}
						},
						error: function(jqXHR, textStatus, errorThrown) {
							console.log(jqXHR);
							console.log(textStatus);
							console.log(errorThrown);
							$that.html('');
						}
					});

				})
			}
		},
		showMessage: function(msg, type) {
			var $msgBox = jQ('body #vpf-msg-cont');
			if (!$msgBox.length) {
				jQ('body').append('<div id="vpf-msg-cont" class="vpf-slide-modal ' + type + '"><div class="inner"></div></div>');
				$msgBox = jQ('body #vpf-msg-cont');
			} else {
				$msgBox.addClass(type);
			}
			jQ('.inner', $msgBox).html('<p>' + msg + '</p>');
			$msgBox.css('z-index', '69999').addClass('vpf-show-slide-modal');
			setTimeout(function() {
				$msgBox.removeClass('vpf-show-slide-modal').css('z-index', '-1').removeClass(type);
			}, 3000);
			setTimeout(function() {
				jQ('.inner', $msgBox).html('');
			}, 3500);
		},
		getTextNodesIn: function(node, includeWhitespaceNodes) {
			var textNodes = [],
				nonWhitespaceMatcher = /\S/;

			function getTextNodes(node) {
				if (node.nodeType == 3) {
					if (includeWhitespaceNodes || nonWhitespaceMatcher.test(node.nodeValue)) {
						textNodes.push(node);
					}
				} else {
					for (var i = 0, len = node.childNodes.length; i < len; ++i) {
						getTextNodes(node.childNodes[i]);
					}
				}
			}

			getTextNodes(node);
			return textNodes;
		},
		fixToolbarButtons: function() {
			var $icon,
				$text,
				text,
				oClass,
				iconMap = {
					'icon-apply': 'aicon-floppy-disk2',
					'icon-save': 'aicon-checkmark',
					'icon-save-copy': 'icon-save-copy',
					'icon-cancel': 'aicon-cancel-circle',
					'icon-question-sign': 'aicon-question'
				}
			buttonMap = {
				'toolbar-apply': 'pure-button green',
				'toolbar-save': 'pure-button blue',
				'toolbar-save-copy': 'pure-button purple',
				'toolbar-cancel': 'pure-button red',
				'toolbar-help': 'pure-button yellow'
			}
			jQ('#vpf-toolbar button').each(function() {
				$text = VPFramework.getTextNodesIn(this);
				jQ($text).wrap('<span class="toolbar-btn-text"/>');
				text = jQ.trim(jQ('.toolbar-btn-text', this).text());
				jQ('.toolbar-btn-text', this).text(text);
				jQ('span', this).replaceClassFromMap(iconMap, true);
				jQ(this).addClassFromParentIDMap(buttonMap, true);
			})
		},
		showHideFields: function(element, target) {
			var state = jQ(element).val();
			if (!state || state == 0) {
				jQ(target).parents('.control-group').hide(300);
			} else {
				jQ(target).parents('.control-group').show(300);
			}
		},
		displayLessGroup: function(heading) {
			var $group = jQ('#vpLessFields');
			var $fieldset = jQ(heading).parents('.less-fieldset');
			$fieldset.siblings().each(function() {
				if (jQ(this).hasClass('active')) {
					jQ(this).removeClass('active')
					jQ('.less-group-content', this).stop(true, true).slideUp(200);
				}
			})
			jQ('.less-group-content', $fieldset).stop(true, true).slideToggle(200);
			$fieldset.toggleClass('active');
			return false;
		}
	}
}

! function($) {
	$(function() {

		$.fn.removeClassPrefix = function(prefix) {
			this.each(function(i, el) {
				var classes = el.className.split(" ").filter(function(c) {
					return c.lastIndexOf(prefix, 0) !== 0;
				});
				el.className = $.trim(classes.join(" "));
			});
			return this;
		};

		$.fn.replaceClassFromMap = function(obj, clearAll) {
			this.each(function(i, el) {
				$.each(obj, function(oldClass, newClass) {
					if ($(el).hasClass(oldClass)) {
						if (clearAll) {
							$(el).attr('class', '').addClass(newClass);
						} else {
							$(el).removeClass(oldClass).addClass(newClass);
						}
					}
				})
			});
			return this;
		};

		$.fn.addClassFromParentIDMap = function(obj, clearOld) {
			this.each(function(i, el) {
				$.each(obj, function(parentID, newClass) {
					if ($(el).parent().attr('id') == parentID) {
						if (clearOld) {
							$(el).attr('class', '').addClass(newClass);
						} else {
							$(el).addClass(newClass);
						}
					}
				})
			});
			return this;
		};

		$('#system-message-container').prependTo('#vpf-content');
		$('body').addClass('vpframework-admin').append('<div id="vpf-overlay"><div></div></div>');
		$('body').append('<div id="vpf-msg-cont" class="vpf-slide-modal"><div class="inner"></div></div>');
		$('ul.nav, ul.nav li').addClass('disabled');
		$('ul.nav li a').removeAttr('href');
		$('ul.nav li ul, ul.nav li a .caret').remove();
		if ($('.navbar-fixed-top').length) {
			$('#vpf-menu, #menuLink').css('top', $('.navbar-fixed-top').height());
		} else {
			$('#vpf-menu, #menuLink').css('top', 0);
		}
		VPFramework.fixToolbarButtons();

		var toggleTimer;
		$('.vpf-menu-toggler').on('click tap', function(e) {
			var $that = $(this);
			e.preventDefault();
			$('body').toggleClass('menu-state-changed');
			$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
			$that.hide();
			if (toggleTimer) {
				clearTimeout(toggleTimer);
			}
			toggleTimer = setTimeout(function() {
				$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
				$that.show();
				$(window).resize();
			}, 300);
			return false;
		});

		$('#vpf-content').on('click tap', function() {
			if ($(document).width() < 768 && !$('body').hasClass('menu-state-changed')) {
				$('body').addClass('menu-state-changed');
				$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
				$('.vpf-menu-toggler').hide();
				if (toggleTimer) {
					clearTimeout(toggleTimer);
				}
				toggleTimer = setTimeout(function() {
					$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
					$('.vpf-menu-toggler').show();
					$(window).resize();
				}, 300);
			}
		});

		$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());

		$(window).on('load', function() {
			if ($(document).width() < 768) {
				$('body').addClass('menu-state-changed');
				setTimeout(function() {
					$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
				}, 300);
			} else {
				$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
			}
			VPFramework.verifyFiles();
			VPFramework.getLatestVersion();
		});

		$(window).resize(function() {
			if ($(document).width() < 768) {
				$('body').addClass('menu-state-changed');
				$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
				if (toggleTimer) {
					clearTimeout(toggleTimer);
				}
				toggleTimer = setTimeout(function() {
					$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
				}, 300);
			} else {
				$('#vpf-toolbar .inner').outerWidth($('#vpf-content').width());
			}
			var areaWidth = $('#vp-file-verification').parents('div.span6').width();
			$('#vp-file-verification pre').width(areaWidth);
		});

		var savedMenu = $.cookie('vpfadmin-active-menu');
		if (savedMenu && $(savedMenu).length) {
			var $selected = $('#vpf-layout .vpf-sidemenu-cont ' + savedMenu);
			$('#vpf-offcanvas-menu a[data-id="' + savedMenu + '"]').parent('li').addClass('active').siblings().removeClass('active');
			$selected.addClass('selected').siblings('.vpf-sidemenu-content').removeClass('selected');
		}

		$('#vpf-offcanvas-menu li a').click(function() {
			if ($(this).parent('li').hasClass('active')) {
				return false;
			}
			var contentID = $(this).attr('href'),
				$selected = $('#vpf-layout .vpf-sidemenu-cont ' + contentID);
			$(this).parent('li').addClass('active').siblings().removeClass('active');
			if (contentID && $selected.length) {
				$selected.addClass('selected fadeIn fast-animated').siblings('.vpf-sidemenu-content').removeClass('selected').removeClass('fadeIn').removeClass('fast-animated');
				setTimeout(function() {
					$selected.removeClass('fadeIn').removeClass('fast-animated');
				}, 1000);
			}
			$(window).resize();
			$.cookie('vpfadmin-active-menu', contentID);
			return false;
		});

		// To show overay use $('body').addClass('vpf-loading');
		var lazyRadioName = $('.vm-image-product-lazyload input:radio:first-child').attr('name');
		VPFramework.showHideFields('input[name="' + lazyRadioName + '"]:radio:checked', '.if-vm-image-product-lazyload');
		$('input[name="' + lazyRadioName + '"]:radio').on('click', function() {
			$(this).trigger('change');
		});
		$('input[name="' + lazyRadioName + '"]:radio').change(function() {
			VPFramework.showHideFields(this, '.if-vm-image-product-lazyload');
		});
		VPFramework.showHideFields('select.merge-vm-category', '.if-merge-vm-category');
		$('select.merge-vm-category').change(function() {
			VPFramework.showHideFields(this, '.if-merge-vm-category');
		});
		VPFramework.showHideFields('select.offcanvas-merge-vm-category', '.if-offcanvas-merge-vm-category');
		$('select.offcanvas-merge-vm-category').change(function() {
			VPFramework.showHideFields(this, '.if-offcanvas-merge-vm-category');
		});
	});
}(jQuery);

(function($) {
	$.ucfirst = function(str) {
		str += '';
		var f = str.charAt(0).toUpperCase();
		return f + str.substr(1);
	};

	$.ucwords = function(str) {
		str = str.toLowerCase().replace(/^[\u00C0-\u1FFF\u2C00-\uD7FF\w]|\s[\u00C0-\u1FFF\u2C00-\uD7FF\w]/g, function(letter) {
			return letter.toUpperCase();
		});
		return str;
	};
})(jQuery);
