/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
var VPF = window.VPF || {};

VPF.jQuery = null;

if("undefined" == typeof jQuery) {
	throw new Error("VP Framework's JavaScript requires jQuery");
} else {
	VPF.jQuery = jQuery.noConflict();
}

VPF.optionsStorage = VPF.optionsStorage || null;

VPF.loadOptions = function(options) {
	// Load form the script container
	if (!options) {
		var elements = document.querySelectorAll('.vpf-script-options.new'),
			str, element, option;

		for (var i = 0, l = elements.length; i < l; i++) {
			element = elements[i];
			str     = element.text || element.textContent;
			option  = JSON.parse(str);

			option ? VPF.loadOptions(option) : null;

			element.className = element.className.replace(' new', ' loaded');
		}

		return;
	}

	// Initial loading
	if (!VPF.optionsStorage) {
		VPF.optionsStorage = options;
	}
	// Merge with existing
	else {
		for (var p in options) {
			if (options.hasOwnProperty(p)) {
				VPF.optionsStorage[p] = options[p];
			}
		}
	}
};

VPF.updateOption = function(p, t) {
	if (VPF.optionsStorage && VPF.optionsStorage.hasOwnProperty(p)) {
		VPF.optionsStorage[p] = t;
	}
};

VPF._ = function(key, def) {
	if(!VPF.optionsStorage) {
		VPF.loadOptions();
	}

	key = !key ? null : key.toUpperCase();
	
	return (VPF.optionsStorage && VPF.optionsStorage.hasOwnProperty(key) && VPF.optionsStorage[key] !== undefined) ? VPF.optionsStorage[key] : def;
};

VPF.isMobile = {
	Android: function() {
		return navigator.userAgent.match(/Android/i);
	},
	BlackBerry: function() {
		return navigator.userAgent.match(/BlackBerry/i);
	},
	iOS: function() {
		return navigator.userAgent.match(/iPhone|iPad|iPod/i);
	},
	Opera: function() {
		return navigator.userAgent.match(/Opera Mini/i);
	},
	Windows: function() {
		return navigator.userAgent.match(/IEMobile/i);
	},
	any: function() {
		var _ = VPF.isMobile;
		var isMobile = (_.Android() || _.BlackBerry() || _.iOS() || _.Opera() || _.Windows());
		if (isMobile) {
			jQuery('html').addClass('isMobile');
		} else {
			jQuery('html').addClass('isComputer');
		}
		return isMobile;
	}
};

VPF.getScrollBarWidth = function(element) {
	if ((navigator.appName == 'Microsoft Internet Explorer') || ((navigator.appName == 'Netscape') && (new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})").exec(navigator.userAgent) != null))) {
		return 0;
	}

	element = !element ? document.body : element;

	var inner = document.createElement('p');
	inner.style.width = "100%";
	inner.style.height = "200px";

	var outer = document.createElement('div');
	outer.style.position = "absolute";
	outer.style.top = "0px";
	outer.style.left = "0px";
	outer.style.visibility = "hidden";
	outer.style.width = "200px";
	outer.style.height = "150px";
	outer.style.overflow = "hidden";
	outer.appendChild(inner);

	element.appendChild(outer);
	var w1 = inner.offsetWidth;
	outer.style.overflow = 'scroll';
	var w2 = inner.offsetWidth;
	if (w1 == w2) w2 = outer.clientWidth;

	element.removeChild(outer);

	return (w1 - w2);
};

(function($) {
	$(function() {

		// Check for navigator and add respective class to HTML element
		VPF.isMobile.any();

		// Plugin to remove all classes with some prefix
		$.fn.removeClassPrefix = function(prefix) {
			this.each(function(i, el) {
				if (!$(el).length) {
					return;
				}
				var classes = el.className.split(" ").filter(function(c) {
					return c.lastIndexOf(prefix, 0) !== 0;
				});
				el.className = $.trim(classes.join(" "));
			});
			return this;
		};

		// Plugin to remove multiple classes
		$.fn.removeClasses = function(classesToRemove) {
			this.each(function(i, el) {
				if (!$(el).length || !classesToRemove) {
					return;
				}
				if (classesToRemove.indexOf(" ")) {
					classesToRemove = classesToRemove.split(" ");
					classesToRemove = $.map(classesToRemove, function(val, i) {
						return $.trim(val);
					});
				} else {
					var temp = classesToRemove;
					classesToRemove = {
						0: temp
					};
					classesToRemove = $.makeArray(classesToRemove);
				}
				var classes = el.className.split(" ").filter(function(c) {
					c = $.trim(c);
					return $.inArray(c, classesToRemove) === -1;
				});
				el.className = $.trim(classes.join(" "));
			});
			return this;
		};

		// Plugin to get pixel value of css properties like margin-left, padding-right etc.
		$.fn.pxVal = function(property) {
			if (this.css(property)) {
				return parseInt(this.css(property).slice(0, -2));
			}
			return 0;
		};

		$.ucfirst = function(str) {
			str += '';
			var f = str.charAt(0).toUpperCase();
			return f + str.substr(1);
		};

		$.ucwords = function(str) {
			str = str.toLowerCase().replace(/^[\u00C0-\u1FFF\u2C00-\uD7FF\w]|\s[\u00C0-\u1FFF\u2C00-\uD7FF\w]/g, function(letter) {
				return letter.toUpperCase();
			});
			return str;
		};

	});
})(jQuery);

var waitForFinalEvent = (function() {
	var timers = {};
	return function(callback, ms, uniqueId) {
		if (!uniqueId) {
			uniqueId = 'An unique ID for each individual call';
		}
		if (timers[uniqueId]) {
			clearTimeout(timers[uniqueId]);
		}
		timers[uniqueId] = setTimeout(callback, ms);
	};
})();