<?php
/**
 * @package        customfilters
 * @copyright      Copyright (C) 2012-2022 breakdesigns.net . All rights reserved.
 * @license        GNU General Public License version 2 or later; see LICENSE.txt
 * @subpackage     mod_cf_filtering
 */

// no direct access
defined('_JEXEC') or die();

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

//load dependencies
require_once dirname(__FILE__) . '/bootstrap.php';

\VmConfig::loadConfig();
Text::script('MOD_CF_FILTERING_INVALID_CHARACTER');
Text::script('MOD_CF_FILTERING_PRICE_MIN_PRICE_CANNOT_EXCEED_MAX_PRICE');
Text::script('MOD_CF_FILTERING_MIN_CHARACTERS_LIMIT');
Text::script('MOD_CF_SHOW_MORE');
Text::script('MOD_CF_SHOW_LESS');

$jlang = Factory::getLanguage();
$jlang->load('com_customfilters');
$jlang->load('com_virtuemart');
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');

$input = Factory::getApplication()->input;
$modObj = new \ModCfFilteringHelper($params, $module);

// Load the filters only when no 'asynchronous loading' or when the 'async' param exists in the request (i.e. is XHR request).
if (!$params->get('asynchronous_loading', 0) || $input->get('async')) {
    $filters = $modObj->getFilters();
    // Do not call it before the \ModCfFilteringHelper::getFilters(), it is altered there.
    $selected_filters = $modObj->getSelectedFilters();
    $layout = $params->get('layout', 'default');
}
else {
    $selected_filters = $modObj->getSelectedFilters();
    $layout = 'placeholders';
}

if (isset($layout)) {
    require(ModuleHelper::getLayoutPath('mod_cf_filtering', $layout));
}
