<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Ajax Search Module
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$unitDesc = JText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_' . $product->product_unit));
$url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id);
?>
<div class="searched-product">
	<?php if($params->get('show_images', 1) && !empty($product->images[0])) : ?>
		<div class="searched-product-image">
			<a href="<?php echo $url ?>">
				<?php echo $product->images[0]->displayMediaThumb ('class="img-responsive"', false); ?>
			</a>
		</div>
	<?php endif; ?>
	<div class="searched-product-info">
		<div class="searched-product-info-inner">
			<div class="searched-product-title">
				<a href="<?php echo $url ?>"><?php echo $product->product_name ?></a>
			</div>
			<?php if($showPrice) : ?>
				<?php if($product->prices['salesPrice'] <= 0 && VmConfig::get ('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
					<?php $ask_url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', false); ?>
					<a class="btn btn-info btn-sm" href="<?php echo $url ?>"><?php echo JText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></a>
				<?php else : ?>
					<div class="searched-product-price">
						<?php if($priceType == 'unitPrice') : ?>
							<?php echo $currency->createPriceDiv('unitPrice', $unitDesc, $product->prices); ?>
						<?php else : ?>
							<?php echo $currency->createPriceDiv($priceType, '', $product->prices); ?>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			<?php endif; ?>
		</div>
	</div>
</div>