<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

class JFormFieldVPTab extends JFormField
{
	protected $type = 'VPTab';

	public function getInput()
	{
		return '';
	}
	
	public function getLabel()
	{
		$tab   = !empty($this->element['tab']) ? (string) $this->element['tab'] : '';
		$class = !empty($this->element['class']) ? ' ' . $this->element['class'] : '';
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html  = '<a href="#" onclick="jQuery(\'joomla-tab button[aria-controls=\\\'' . $tab . '\\\']\').trigger(\'click\');">' . JText::_($this->element['label']) . '</a>';
		}
		else
		{
			$html  = '<a href="#" onclick="jQuery(\'.nav-tabs a[href=\\\'#'. $tab . '\\\']\').tab(\'show\');">' . JText::_($this->element['label']) . '</a>';
		}
		
		if (!empty($this->element['description']))
		{
			$html .= '<div class="muted text-muted' . htmlspecialchars($class) . '">' . JText::_($this->element['description']) . '</div>';
		}
		
		return $html;
	}
}