/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
 */
!(function($) {
	$(document).ready(function() {
		$(document).on('manufacturer.carousel.afterInit', function(e, slider, margin, imgPadding, backgroundColor, borderColor, logoRadius) {
			var $element = slider.$elem || slider.$element;
			var $items = slider.$owlItems || $('.owl-item', $element);
			if (slider && $items.length) {
				margin = parseInt(margin);
				margin = Number(Math.round((margin / 2) + 'e4') + 'e-4');
				$('.manufacturer-carousel-inner', $items).css({
					'padding-left': margin,
					'padding-right': margin
				});
				$('.manufacturer-carousel-inner > a', $items).css({
					'padding': (imgPadding ? imgPadding : ''),
					'background-color': (backgroundColor ? backgroundColor : ''),
					'border-color': (borderColor ? borderColor : ''),
					'border-radius': (logoRadius ? logoRadius : '')
				});
				if(slider.$elem) {
					if ($('.owl-pagination:visible', slider.$elem).length) {
						slider.$elem.addClass('pagination-active');
					}
				} else if (slider.$element) {
					if ($('.owl-dots:visible', slider.$element).length) {
						slider.$element.addClass('pagination-active');
					}
				}
			}
		});
	});
})(jQuery);