<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die('Restricted access');

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart', true);

JLoader::register('VmImage', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/image.php');
JLoader::register('TableMedias', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/medias.php');
JLoader::register('TableManufacturer_medias', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/manufacturer_medias.php');
JLoader::register('TableManufacturers', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/manufacturers.php');
JLoader::register('VirtueMartModelManufacturer', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/manufacturer.php');

class VirtueMartModelManufacturer_extended extends VirtueMartModelManufacturer
{
	public $categories_id = null;
	public $selected_manufacturers = array();
	
	protected static $_manufacturers = array();
		
	function __construct() 
	{
		parent::__construct('virtuemart_manufacturer_id');
	}

	public function getManufacturers($onlyPublished = false, $noLimit = false, $getMedia = false)
	{
		$hash = serialize($this->selected_manufacturers) . (int)$this->categories_id . VmConfig::$vmlang . (int)$onlyPublished . (int)$noLimit . (int)$getMedia;

		if(isset(self::$_manufacturers[$hash]))
		{
			return $_manufacturers[$hash];
		}
		
		$app = JFactory::getApplication();
		$this->_noLimit = $noLimit;
		
		$where = array();

		if($this->categories_id > 0)
		{
			$where[] .= ' `m`.`virtuemart_manufacturercategories_id` = '. $this->categories_id;
		}

		$joinedTables = ' FROM `#__virtuemart_manufacturers` as m';		
		$select = ' `m`.*';
		
		$ordering = $this->_getOrdering();
		$select .= ',`#__virtuemart_manufacturers_' . VmConfig::$vmlang . '`.*, mc.`mf_category_name` ';
		$joinedTables .= ' INNER JOIN `#__virtuemart_manufacturers_' . VmConfig::$vmlang . '` USING (`virtuemart_manufacturer_id`) ';
		$joinedTables .= ' LEFT JOIN `#__virtuemart_manufacturercategories_' . VmConfig::$vmlang . '` AS mc on  mc.`virtuemart_manufacturercategories_id`= `m`.`virtuemart_manufacturercategories_id` ';
		
		if ($onlyPublished)
		{
			$where[] .= ' `m`.`published` = 1';
		}
		
		if(!empty($this->selected_manufacturers))
		{			
			$where[] .= ' `m`.`virtuemart_manufacturer_id` IN (' . implode(',', $this->selected_manufacturers) . ')';
		}

		$groupBy = ' ';
		if($getMedia)
		{
			$select .= ',mmex.virtuemart_media_id ';
			$joinedTables .= 'LEFT JOIN `#__virtuemart_manufacturer_medias` as mmex ON `m`.`virtuemart_manufacturer_id`= mmex.`virtuemart_manufacturer_id` ';
			$groupBy = ' GROUP BY `m`.`virtuemart_manufacturer_id` ';
		}
		
		$whereString = ' ';
		
		if(count($where) > 0) $whereString = ' WHERE ' . implode(' AND ', $where) . ' ' ;

		$_manufacturers[$hash] = $this->_data = $this->exeSortSearchListQuery(0, $select, $joinedTables, $whereString, $groupBy, $ordering);
		
		return $_manufacturers[$hash];
	}

}