<?php 
/**
 * --------------------------------------------------------------------------------------------
 * VP Manufacturer Carousel - Joomla! Module for VirtueMart Store
 * --------------------------------------------------------------------------------------------
 * @package    VP Manufacturer Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

if(!class_exists('ModVPManufacturerCorouselHelper')) require __DIR__ . '/helper.php';

$cacheid = md5($module->id);

$cacheparams               = new stdClass;
$cacheparams->cachemode    = 'id';
$cacheparams->class        = 'ModVPManufacturerCorouselHelper';
$cacheparams->method       = 'getList';
$cacheparams->methodparams = $params;
$cacheparams->modeparams   = $cacheid;

$manufacturers             = JModuleHelper::moduleCache($module, $params, $cacheparams);

if(!empty($manufacturers))
{
	// Initialize some variables
	$app                     = JFactory::getApplication();
	$doc                     = JFactory::getDocument();
	$root                    = JUri::root(true);
	$has_vpframework         = JPluginHelper::isEnabled('system', 'vpframework');
	$input                   = $app->input;
	$vendorId                = $input->getInt('vendorid', 1);
	$module_id               = 'vp-manufacturer-carousel-' . $module->id;	

	// Module Parameters
	$margin                  = (int) $params->get('margin', 15);
	$imgPadding              = $params->get('imgPadding', 2) ? (int) $params->get('imgPadding', 2) : 'null';
	$backgroundColor         = $params->get('backgroundColor', '') ? "'" . $params->get('backgroundColor') . "'" : 'null';
	$borderColor             = $params->get('borderColor', '') ? "'" . $params->get('borderColor') . "'" : 'null';
	$logoRadius              = (int) $params->get('logoRadius', 2);
	$itemsDesktop            = (int) $params->get('itemsDesktop', 5);
	$itemsDesktopSmall       = (int) $params->get('itemsDesktopSmall', 4);
	$itemsTablet             = (int) $params->get('itemsTablet', 3);
	$itemsMobile             = (int) $params->get('itemsMobile', 2);
	$lazyLoad                = $params->get('lazyLoad', 1) ? 'true' : 'false';
	$navigation              = $params->get('navigation', 1) ? 'true' : 'false';
	$pagination              = $params->get('pagination', 1) ? 'true' : 'false';
	$pagination_position     = $params->get('pagination_position', 'bottom-right');
	$loop                    = $params->get('loop', 1) ? 'true' : 'false';
	$rewindNav               = $params->get('rewindNav', 1) ? 'true' : 'false';
	$slideSpeed              = (int) $params->get('slideSpeed', 200);
	$paginationSpeed         = (int) $params->get('paginationSpeed', 800);
	$rewindSpeed             = (int) $params->get('rewindSpeed', 600);
	$autoplayTimeout         = (int) $params->get('autoplayTimeout', 10000);
	$autoplay                = $params->get('autoplay', 1) ? $autoplayTimeout : 'false';
	$scrollPerPage           = $params->get('scrollPerPage', 1) ? 'true' : 'false';
	$stopOnHover             = $params->get('stopOnHover', 1) ? 'true' : 'false';
	$linkType                = $params->get('linkType', 'listing');
	$Itemid                  = (int) $params->get('Itemid', '');
	$headerText              = $params->get('headerText', '');
	$footerText              = $params->get('footerText', '');
	$moduleclass_sfx         = htmlspecialchars($params->get('moduleclass_sfx', ''));
	$total                   = count($manufacturers);
	$load_owlcarousel        = $params->get('load_owlcarousel', 1);
	$owl_version             = ModVPManufacturerCorouselHelper::getOWLVersion($params);
	
	// We must load jQuery library
	ModVPManufacturerCorouselHelper::loadjQuery($params);
	
	if($load_owlcarousel)
	{
		if($has_vpframework)
		{
			if(!class_exists('plgSystemVPFrameworkHelper'))
			{
				require(JPATH_SITE . '/plugins/system/vpframework/helper.php');
			}

			// Register helper class autoloader
			plgSystemVPFrameworkHelper::autoloadRegister();
			
			$template = plgSystemVPFrameworkHelper::getTemplate();
			
			$template->loadJSLibraries(array('jquery.owl.carousel.min'));
		}
		else
		{
			if($owl_version == 2)
			{
				$doc->addScript($root . '/modules/mod_vp_manufacturer_carousel/assets/js/owl-carousel2/jquery.owl.carousel.min.js');
				$doc->addStyleSheet($root . '/modules/mod_vp_manufacturer_carousel/assets/css/owl-carousel2/jquery.owl.carousel.min.css');
			}
			else
			{
				$doc->addScript($root . '/modules/mod_vp_manufacturer_carousel/assets/js/jquery.owl.carousel.min.js');
				$doc->addStyleSheet($root . '/modules/mod_vp_manufacturer_carousel/assets/css/jquery.owl.carousel.min.css');
			}
		}
	}
	
	$doc->addScript($root . '/modules/mod_vp_manufacturer_carousel/assets/js/module.js');
	$doc->addStyleSheet($root . '/modules/mod_vp_manufacturer_carousel/assets/css/module.css');
	
	$pluginScript = "
  jQuery(document).ready(function($){
  	if($.fn.owlCarousel && $.fn.owlCarousel.options) {
	    $('#" . $module_id . "').owlCarousel({
	      items: " . $itemsDesktop . ",
	      itemsDesktop: [1200, " . $itemsDesktop . "],
	      itemsDesktopSmall: [992, " . $itemsDesktopSmall . "],
	      itemsTablet: [768 ," . $itemsTablet . "],
	      itemsMobile: [479 ," . $itemsMobile . "],
	      lazyLoad: " . $lazyLoad . ",
	      autoPlay: " . $autoplay . ",
	      theme: 'side-nav-theme',
	      navigation: " . $navigation . ",
	      pagination: " . $pagination . ",
	      slideSpeed: " . $slideSpeed . ",
	      paginationSpeed: " . $paginationSpeed . ",
	      rewindSpeed: " . $rewindSpeed . ",
	      stopOnHover: " . $stopOnHover . ",
	      rewindNav: " . $rewindNav . ",
	      navigationText: false,
	      autoHeight: false,
	      scrollPerPage: " . $scrollPerPage . ",
	      transitionStyle : 'fadeUp',
	      afterInit: function() {
	      	$(document).trigger('manufacturer.carousel.afterInit', [this, " . $margin . ", " . $imgPadding . ", " . $backgroundColor . ", " . $borderColor . ", " . $logoRadius . "]);
	      }
	    });
		} else {
	    $('#" . $module_id . "').addClass('owl-version-2').owlCarousel({
	      items: " . $itemsDesktop . ",
	      lazyLoad: " . $lazyLoad . ",
	      autoplay: " . ($params->get('autoplay', 1) ? 'true' : 'false') . ",
	      autoplayTimeout: " . $autoplayTimeout . ",
	      theme: 'side-nav-theme',
	      nav: " . $navigation . ",
	      dots: " . $pagination . ",
	      slideSpeed: " . $slideSpeed . ",
	      paginationSpeed: " . $paginationSpeed . ",
	      rewindSpeed: " . $rewindSpeed . ",
	      autoplayHoverPause: " . $stopOnHover . ",
	      rewind: " . $rewindNav . ",
	      navText: false,
	      autoHeight: true,
	      slideBy: " . ($params->get('scrollPerPage', 1) ? "'page'" : 1) . ",
	      transitionStyle : 'fadeUp',
	      onInitialized: function(e) {
	      	$(document).trigger('manufacturer.carousel.afterInit', [this, " . $margin . ", " . $imgPadding . ", " . $backgroundColor . ", " . $borderColor . ", " . $logoRadius . "]);
	      },
				responsive : {
				    0 : {
				        items: " . $itemsDesktop . "
				    },
				    479 : {
				        items: " . $itemsMobile . "
				    },
				    768 : {
				        items: " . $itemsTablet . "
				    },
				    992 : {
				        items: " . $itemsDesktopSmall . "
				    },
				    1200 : {
				        items: " . $itemsDesktop . "
				    }
				}
	    });
		}
  });
 ";
	
	$js  = "\n" . '<script type="text/javascript" defer="defer">' . "\n";
	$js .= '//<![CDATA[';
	$js .= $pluginScript;
	$js .= '//]]>' . "\n";
	$js .= '</script>' . "\n";
	
	require JModuleHelper::getLayoutPath('mod_vp_manufacturer_carousel', $params->get('layout', 'default'));
	
	if($has_vpframework)
	{
		echo $js;
	}
	else
	{
		$doc->addScriptDeclaration($pluginScript);
	}
}