<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Mini Cart Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Mini Cart Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

VmConfig::loadConfig();

JLoader::register('CurrencyDisplay',             JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/currencydisplay.php');
JLoader::register('VirtueMartModelCustomfields', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/customfields.php');

abstract class ModVPMiniCartHelper
{
	public static $cart = null;
	
	public static function getCart($params)
	{
		JLoader::register('VirtueMartCart', JPATH_ROOT . '/components/com_virtuemart/helpers/cart.php');
		
		VmConfig::loadJLang('mod_virtuemart_cart', true);
		VmConfig::loadJLang('com_virtuemart', true);
		
		if (static::$cart === null)
		{
			$doc  = JFactory::getDocument();
			$type = strtoupper($doc->getType());
			$cart = VirtueMartCart::getCart(false);
			
			if ($params->get('delay_loading', 1) && $type == 'HTML')
			{
				$cart->prepareAjaxData();
			}
			else
			{
				$cart->prepareCartData();
			}

			if (empty($cart->cartPrices['billTotal']) || $cart->cartPrices['billTotal'] < 0 || empty($cart->products))
			{
				$cart->cartPrices['billTotal'] = 0;
			}
			
			static::$cart = $cart;
		}
		
		return static::$cart;
	}
	
	
	public static function getProductCount($params)
	{
		$cart  = self::getCart($params);
		$count = 0;
		
		if (!empty($cart->products))
		{
			foreach ($cart->products as $i=>$product)
			{
				$count += $product->quantity;
			}
		}
		
		return $count;
	}
	
	public static function getUniqueProductCount($params)
	{
		$cart  = self::getCart($params);
		$count = 0;
		
		if (!empty($cart->products))
		{
			$count = count($cart->products);
		}
		
		return $count;
	}
	
	public static function getCartLink($params)
	{
		$cart = self::getCart($params);

		if (false && ($cart->_dataValidated == true)) 
		{
			$taskRoute = '&task=confirm';
			$text = vmText::_('COM_VIRTUEMART_ORDER_CONFIRM_MNU');
		}
		else 
		{
			$taskRoute = '';
			$text = vmText::_('COM_VIRTUEMART_CART_SHOW');
		}
		
		$url = JRoute::_("index.php?option=com_virtuemart&view=cart" . $taskRoute, true, VmConfig::get('useSSL', 0));
		
		return array($text, $url);
	}
	
	public static function getAjax()
	{
		if (JModuleHelper::isEnabled('mod_vp_mini_cart'))
		{
			if ($module = JModuleHelper::getModule('mod_vp_mini_cart'))
			{
				$context = JModuleHelper::renderModule($module);
				
				return self::_return($context);
			}
		}
	}
	
	private static function _return($context)
	{
		$obLevel = ob_get_level();
		
		if ($obLevel)
		{
			while ($obLevel > 0) 
			{
				ob_end_clean();
				$obLevel --;
			}
		}
		else
		{
			ob_clean();
		}
		
		if (isset($_SERVER['HTTP_ACCEPT']) && (strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false)) 
		{
			header('Content-type: application/text');
		} 
		else 
		{
			header('Content-type: application/json');
		}
		
		header('Cache-Control: public,max-age=1,must-revalidate');
		header('Expires: ' . gmdate('D, d M Y H:i:s', ($_SERVER['REQUEST_TIME'] + 1)) . ' GMT');
		header('Last-modified: ' . gmdate('D, d M Y H:i:s', $_SERVER['REQUEST_TIME']) . ' GMT');
		
		if (function_exists('header_remove')) 
		{
			header_remove('Pragma');
		}

		echo json_encode(array('html' => $context));
		
		JFactory::getApplication()->close();
	}
}