<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted access');

$position			= 'addtocart';
$class				= 'product-fields';
$customTitle	= false;
$custom_title	= null;
?>
<?php if (!empty($product->customfieldsSorted[$position])) : ?>
	<div class="<?php echo $class?>">
	
		<?php if ($customTitle && isset($product->customfieldsSorted[$position][0])) : ?>
			<?php 
			$field = $product->customfieldsSorted[$position][0];
			$titleClass = !empty($field->custom_tip) ? 'class="product-fields-title hasTooltip"' : 'class="product-fields-title"';
			$title = !empty($field->custom_tip) ? ' title="' . vmText::_($field->custom_tip) . '"' : '';			
			?>
			<div class="product-fields-title-wrapper">
				<span <?php echo $titleClass . $title ?>><?php echo vmText::_($field->custom_title) ?></span>
			</div>
		<?php endif; ?>
		
		<?php $custom_title = null; ?>
		<?php foreach ($product->customfieldsSorted[$position] as $field) : ?>
			<?php if (!$field->is_hidden) : ?> 
				<div class="product-field product-field-type-<?php echo $field->field_type ?>">
					<?php if (!$customTitle && ($field->custom_title != $custom_title) && $field->show_title) : ?>
						<?php 
						$titleClass = !empty($field->custom_tip) ? 'class="product-fields-title hasTooltip"' : 'class="product-fields-title"';
						$title = !empty($field->custom_tip) ? ' title="' . vmText::_($field->custom_tip) . '"' : '';			
						?>
						<div class="product-fields-title-wrapper">
							<span <?php echo $titleClass . $title ?>><?php echo vmText::_($field->custom_title) ?></span>
						</div>
					<?php endif; ?>
					<?php if (!empty($field->display)) : ?>
						<div class="product-field-display">
							<?php echo $field->display ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($field->custom_desc)) : ?>
						<div class="product-field-desc"><?php echo vmText::_($field->custom_desc) ?></div> 
					<?php endif; ?>
				</div>
				<?php $custom_title = $field->custom_title; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
<?php endif; ?>