<?php 
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;
?>
<div class="vppl<?php echo $params->get('moduleclass_sfx') ?>">
	<ul class="vppl-list">
		<?php foreach ($products as $product) : ?>
			<?php
			$productLink = empty($product->link) ? $product->canonical : $product->link;
			$Itemid      = VPFrameworkVM::getMenuId($productLink);
			$ItemidStr   = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
			$productLink = JRoute::_($productLink . $ItemidStr);
			?>
			<li>
				<div class="vppl-inner">
					<div class="row row-condensed">
						<div class="col-xs-4">
							<div class="vppl-image-cont">
								<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>">
									<?php echo $product->images[0]->displayMediaThumb('class="responsive-image"', false); ?>
								</a>
							</div>
						</div>
						<div class="col-xs-8">
							<h4 class="vppl-name">
								<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name; ?></a>
							</h4>
							<div class="vppl-price-cont">
								<?php require JModuleHelper::getLayoutPath('mod_vp_product_list', $params->get('layout', 'default') . '_price'); ?>
							</div>
							<?php if ($showRating && !empty($product->rating)) : ?>
								<div class="vppl-rating-cont">
									<?php require JModuleHelper::getLayoutPath('mod_vp_product_list', $params->get('layout', 'default') . '_rating'); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</li>
		<?php endforeach; ?>
	</ul>
</div>