/**
 * --------------------------------------------------------------------------------------------
 * VP Responsive Slider - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Responsive Slider Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
 */
if (typeof VPFRS === "undefined" || typeof VPFRS === undefined) {

	var jQ = jQuery.noConflict();

	var VPFRS = {
		inTimer: {},
		outTimer: {},

		getVPFAnimation: function(value) {
			if (value != 'random') {
				return value;
			}
			var animations = window.vpfrs_animations;
			return animations[Math.floor(Math.random() * animations.length)];
		},

		showCaption: function(that) {
			if (!jQ('html').hasClass('old-ie')) {
				var currentIndex = that.owl.currentItem;
				var currentItem = that.$owlItems[currentIndex];
				var $currentItem = jQ(that.$owlItems[currentIndex]);
				if ($currentItem.find('.vpfrs-caption').length) {
					var $caption = $currentItem.find('.vpfrs-caption');
					var $captionInner = $caption.find('.vpfrs-caption-inner');
					var animation = $caption.data('animation');
					if (animation && animation != 'none') {
						$captionInner.addClass('caption-hidden');
						animation = VPFRS.getVPFAnimation(animation);
						if (VPFRS.inTimer[currentIndex]) {
							clearTimeout(VPFRS.inTimer[currentIndex]);
						}
						VPFRS.inTimer[currentIndex] = setTimeout(function() {
							$captionInner.removeClass('animated').removeClass(animation).removeClass('caption-hidden').addClass(animation + ' animated');
							if (VPFRS.outTimer[currentIndex]) {
								clearTimeout(VPFRS.outTimer[currentIndex]);
							}
							VPFRS.outTimer[currentIndex] = setTimeout(function() {
								$captionInner.removeClass('animated').removeClass(animation);
							}, 1000)
						}, 500);
					}
				}
			}
		}
	}
}
jQuery(document).ready(function($) {
	if (/MSIE\s([\d.]+)/.test(navigator.userAgent) ? new Number(RegExp.$1) < 10 : false) {
		$('html').addClass('old-ie');
	} else if (/constructor/i.test(window.HTMLElement)) {
		$('html').addClass('safari');
	}
});