<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Responsive Slider - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Responsive Slider Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
// No direct access
defined('_JEXEC') or die();

JFormHelper::loadFieldClass('List');

class JFormFieldVPFAnimation extends JFormFieldList
{
	protected $type = 'VPFAnimation';
	
	public $for = null;
	
	public $direct_call = false;
	
	protected static $animations = null;

	public function getOptions()
	{
		if ($this->for)
		{
			$for = $this->for;
		}
		else
		{
			$for = !empty($this->element['for']) ? strtolower($this->element['for']) : 'all';
		}
		
		$animationGroups = self::_getAnimations();
		$options = array();

		if ($for != 'all')
		{
			$escape_1 = ($for == 'entrance') ? 'exit' : 'entrance';
			$escape_2 = ($for == 'entrance') ? 'out' : 'in';
			
			foreach ($animationGroups as $group => $animations)
			{
				if (strpos($group, $escape_1) === false)
				{
					foreach ($animations as $animation => $active)
					{
						if ($active && strpos(strtolower($animation), $escape_2) === false)
						{
							$options[] = JHtml::_('select.option', $animation, preg_replace('/(?<!\ )[A-Z]/', ' $0', ucfirst($animation)), 'value', 'text');
						}
					}
				}
			}
		}
		else
		{
			foreach ($animationGroups as $group => $animations)
			{
				$group = ucwords(str_replace('_', ' ', $group));
				
				if (!isset($options[$group]))
				{
					$options[$group] = array();
				}
				
				foreach ($animations as $animation => $active)
				{
					if ($active)
					{
						$options[$group][] = JHtml::_('select.option', $animation, preg_replace('/(?<!\ )[A-Z]/', ' $0', ucfirst($animation)), 'value', 'text');
					}
				}
			}
		}
		
		if ($this->direct_call)
		{
			return $options;
		}
		
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}
	
	protected function getInput()
	{
		$for = !empty($this->element['for']) ? strtolower($this->element['for']) : 'all';
		$options = $this->getOptions();
		
		
		if ($for == 'all')
		{
			$attr = '';

			// Initialize some field attributes.
			$attr .= !empty($this->class) ? ' class="' . $this->class . '"' : '';
			$attr .= $this->disabled ? ' disabled' : '';
			$attr .= !empty($this->size) ? ' size="' . $this->size . '"' : '';
			$attr .= $this->multiple ? ' multiple' : '';
			$attr .= $this->required ? ' required aria-required="true"' : '';
			$attr .= $this->autofocus ? ' autofocus' : '';

			// Initialize JavaScript field attributes.
			$attr .= !empty($this->onchange) ? ' onchange="' . $this->onchange . '"' : '';
			
			return JHtml::_(
				'select.groupedlist', $options, $this->name,
				array(
					'list.attr' => $attr, 'id' => $this->id, 'list.select' => $this->value, 'group.items' => null, 'option.key.toHtml' => false,
					'option.text.toHtml' => false
				)
			);
		}
		
		return parent::getInput();
	}
	
	protected static function _getAnimations()
	{
		if (static::$animations === null)
		{
			$app = JFactory::getApplication();
			$json = JPath::clean(__DIR__ . '/vpfanimation/animate-config.json');
			
			if (!file_exists($json))
			{
				$app->enqueueMessage('JFormFieldVPFAnimation::_getAnimations missing file ' . $json, 'error');
				return false;
			}
			
			$string = file_get_contents($json);
			
			if (!$string)
			{
				$app->enqueueMessage('JFormFieldVPFAnimation::_getAnimations no data found in ' . $json, 'error');
				return false;
			}
			
			if (is_string($string))
			{
				static::$animations = json_decode($string, true);
			}
			else
			{
				static::$animations = array();
			}
		}

		return static::$animations;
	}
	
}