<?php 
/**
 * --------------------------------------------------------------------------------------------
 * VP Responsive Slider - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Responsive Slider Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('modVPResponsiveSliderHelper', __DIR__ . '/helper.php');

$cacheid                   = md5($module->id);
$cacheparams               = new stdClass;
$cacheparams->cachemode    = 'id';
$cacheparams->class        = 'modVPResponsiveSliderHelper';
$cacheparams->method       = 'getList';
$cacheparams->methodparams = $params;
$cacheparams->modeparams   = $cacheid;

$slides = JModuleHelper::moduleCache($module, $params, $cacheparams);

if (!empty($slides))
{
	$base                   = JURI::base(true);
	$doc                    = JFactory::getDocument();
	$app                    = JFactory::getApplication();
	$has_vpframework        = JPluginHelper::isEnabled('system', 'vpframework');
	
	$transitionStyle        = $params->get('transitionStyle', 'false');
	$navigation             = $params->get('navigation', 1) ? 'true' : 'false';
	$pagination             = $params->get('pagination', 1) ? 'true' : 'false';
	$pagination_position    = $params->get('pagination_position', 'bottom-right');
	$loop                   = $params->get('loop', 1) ? 'true' : 'false';
	$rewindNav              = $params->get('rewindNav', 1) ? 'true' : 'false';
	$lazyLoad               = $params->get('lazyLoad', 0) ? 'true' : 'false';
	$slideSpeed             = (int) $params->get('slideSpeed', 200);
	$paginationSpeed        = (int) $params->get('paginationSpeed', 800);
	$rewindSpeed            = (int) $params->get('rewindSpeed', 600);
	$autoplayTimeout        = (int) $params->get('autoplayTimeout', 10000);
	$autoplay               = $params->get('autoplay', 1) ? $autoplayTimeout : 'false';
	$stopOnHover            = $params->get('stopOnHover', 1) ? 'true' : 'false';
	$load_owlcarousel       = $params->get('load_owlcarousel', 1);
	$heightDesktop          = (int) $params->get('heightDesktop', 0);
	$heightDesktopSmall     = (int) $params->get('heightDesktopSmall', 0);
	$heightTablet           = (int) $params->get('heightTablet', 0);
	$heightMobile           = (int) $params->get('heightMobile', 0);
	$moduleclass_sfx        = htmlspecialchars($params->get('moduleclass_sfx', ''));
	
	$animations             = modVPResponsiveSliderHelper::getAnimations();
	$module_id              = 'vpf-responsive-slider-' . $module->id;

	JHtml::_('jquery.framework');
	
	if ($has_vpframework)
	{
		JLoader::register('plgSystemVPFrameworkHelper', JPATH_SITE . '/plugins/system/vpframework/helper.php');
		
		// Register helper class autoloader
		plgSystemVPFrameworkHelper::autoloadRegister();
		
		$template = plgSystemVPFrameworkHelper::getTemplate();
		
		$template->loadJSLibraries(array('jquery.owl.carousel.min'));
		
		JHtml::stylesheet('vpframework/animate.css', array('relative' => true));
		JHtml::stylesheet('vpframework/jquery.owl.transitions.css', array('relative' => true));
	}
	elseif ($load_owlcarousel)
	{
		$doc->addScript($base . '/modules/mod_vp_responsive_slider/assets/js/jquery.owl.carousel.min.js');
		$doc->addStyleSheet($base . '/modules/mod_vp_responsive_slider/assets/css/jquery.owl.carousel.min.css');
		$doc->addStyleSheet($base . '/modules/mod_vp_responsive_slider/assets/css/animate.css');
		$doc->addStyleSheet($base . '/modules/mod_vp_responsive_slider/assets/css/jquery.owl.transitions.css');
	}
	
	$doc->addScript($base . '/modules/mod_vp_responsive_slider/assets/js/module.js');
	$doc->addStyleSheet($base . '/modules/mod_vp_responsive_slider/assets/css/module.css');
	
	$js  = "\n" . '<script type="text/javascript">' . "\n";
	$js .= '//<![CDATA[' . "\n";
	
	static $animations_defined = false;
	
	if (!$animations_defined)
	{
		$js .= $doc->_getTab() . "window.vpfrs_animations = " . json_encode($animations) . ";";
		$animations_defined = true;
	}
	
	$js .= "
  jQuery(document).ready(function($){
    $('#" . $module_id . "').owlCarousel({
        singleItem: true,
        itemsScaleUp: true,
        autoPlay: " . $autoplay . ",
        theme: 'vpfrs-theme',
        navigation: " . $navigation . ",
        pagination: " . $pagination . ",
        slideSpeed: " . $slideSpeed . ",
        paginationSpeed: " . $paginationSpeed . ",
        rewindSpeed: " . $rewindSpeed . ",
        stopOnHover: " . $stopOnHover . ",
        rewindNav: " . $rewindNav . ",
        navigationText: false,
        transitionStyle: " . ($transitionStyle != 'false' ? "'" . $transitionStyle . "'" : "false") . ",
        autoHeight: true,
        lazyLoad: " . $lazyLoad . ",
        afterAction: function() {
          VPFRS.showCaption(this);
        }
    });
  });";
	$js .= "\n" . '//]]>' . "\n";
	$js .= '</script>' . "\n";
	
	$css = '';
	
	if ($heightMobile)
	{
		$css .= '.vpfrs-theme>.vpfrs-item,.vpfrs-theme .owl-item.loading{min-height:' . $heightMobile . 'px}';
	}
	
	if ($heightTablet)
	{
		$css .= '@media(min-width:768px and max-width:991px){.vpfrs-theme>.vpfrs-item,.vpfrs-theme .owl-item.loading{min-height:' . $heightTablet . 'px}}';
	}
	
	if ($heightDesktopSmall)
	{
		$css .= '@media(min-width:992px and max-width:1199px){.vpfrs-theme>.vpfrs-item,.vpfrs-theme .owl-item.loading{min-height:' . $heightDesktopSmall . 'px}}';
	}
	
	if ($heightDesktop)
	{
		$css .= '@media(min-width:1200px){.vpfrs-theme>.vpfrs-item,.vpfrs-theme .owl-item.loading{min-height:' . $heightDesktop . 'px}}';
	}
	
	if (!empty($css))
	{
		$doc->addStyleDeclaration($css);
	}
	
	require JModuleHelper::getLayoutPath('mod_vp_responsive_slider', $params->get('layout', 'default'));
	echo $js;
}
