<?php
/**
 * @package Ajax Custom Fields For All
 * @copyright   Copyright (C)2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

require_once(JPATH_PLUGINS .DIRECTORY_SEPARATOR. 'system' . DIRECTORY_SEPARATOR. 'customfieldsforallbase' . DIRECTORY_SEPARATOR . 'RenderFields.php');

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Authentication\Authentication;
use Joomla\CMS\Language\Text;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Customfield;

class plgAjaxCustomfieldsforall extends CMSPlugin
{
    /**
     * Returns the html of the custom values collection
     *
     * @return string
     * @throws Exception
     * @since 1.0.0
     */
    public function onAjaxGetCustomValues()
    {
        // Do not throw warnings and notices. They break the json response
        error_reporting(E_ERROR);

        $user = Factory::getApplication()->getIdentity();

        // Only admin access and ACL check
        if (!Factory::getApplication()->isClient('administrator') ||
            !($user->authorise('core.admin', 'com_virtuemart') || $user->authorise('vm.product.edit', 'com_virtuemart'))) {
            $response = new \stdClass();
            $response->status        = Authentication::STATUS_FAILURE;
            $response->error_message = Text::_('JLIB_RULES_NOT_ALLOWED');
            return json_encode($response);
        }

        $results = '';
        $fieldname = 'cf_val';
        $input = Factory::getApplication()->input;
        $virtuemart_custom_id = $input->get('virtuemart_custom_id', 0, 'INT');
        $search = $input->get('search', '', 'string');
        $page = $input->get('page', 1, 'INT');
        $listLimit = $this->params->get('limit', 60);
        $listStart = ((int)$page-1) * (int)$listLimit;
        $format = $input->get('format', 'raw', 'CMD');
        $parentPlugin = $input->get('parentPlugin', '', 'CMD');
        $custom_params = [];

        if($virtuemart_custom_id) {
            $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);
            $custom_params = $customfield->getCustomfieldParams($virtuemart_custom_id);
            $custom_params['single_entry'] = !empty($custom_params['is_price_variant']) ? true : false;
        }

        // Return html
        if($format == 'raw' || $format == 'html') {
            $renderFields = new RenderFields();

            $results = $renderFields->fetchCustomvalues($fieldname, $virtuemart_custom_id, '', 0, $custom_params,
                $listStart, $listLimit, $search);
        }

        elseif ($format == 'json') {
            $withParent = $parentPlugin == 'dependentcustomfieldsforall' ? true : false;
            $block = new ProductRow($parentPlugin, 0, $virtuemart_custom_id);
            $customfieldValues = $block->getCustomValues($withParent, $listStart, $listLimit, $search);
            $customfieldValuesRows = [];
            foreach ($customfieldValues as $customfieldValue) {
                $valueObj = new \stdClass();
                $valueObj->id = $customfieldValue->customsforall_value_id;
                $valueObj->text = $customfieldValue->customsforall_value_name;
                $customfieldValuesRows[] = $valueObj;
            }
            $jsonDummyObj = new \stdClass();
            $jsonDummyObj->results = $customfieldValuesRows;
            $jsonDummyObj->pagination = new \stdClass();
            $jsonDummyObj->pagination->more = count($customfieldValues) == $listLimit ? true : false;
            $results = json_encode($jsonDummyObj);
        }

        return $results;
    }

    /**
     * Save a custom value
     *
     * @return false|string
     * @throws Exception
     * @since 2.0.0
     */
    public function onAjaxSaveCustomValue()
    {
        // Do not throw warnings and notices. They break the json response
        error_reporting(E_ERROR);

        $user = Factory::getApplication()->getIdentity();

        // Only admin access and ACL check
        if (!Factory::getApplication()->isClient('administrator') || !$user->authorise('core.admin', 'com_virtuemart')) {
            $response = new \stdClass();
            $response->status        = Authentication::STATUS_FAILURE;
            $response->error_message = Text::_('JLIB_RULES_NOT_ALLOWED');
            return json_encode($response);
        }

        $input = Factory::getApplication()->input;
        $dataPost = $input->post->get('cf_val', [], 'ARRAY');

        if($dataPost) {
            $virtuemart_custom_id = $input->get('virtuemart_custom_id', 0, 'INT');
            if($virtuemart_custom_id) {
                $parentPlugin = $input->get('parentPlugin', '', 'cmd');
                $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);
                $storedRecord = $customfield->store($dataPost, false);
                return json_encode(reset($storedRecord));
            }
        }
        return json_encode(['Saved' => false]);
    }

    /**
     * Delete a custom value
     *
     * @return false|string
     * @throws Exception
     * @since 2.0.0
     */
    public function onAjaxDeleteCustomValue()
    {
        // Do not throw warnings and notices. They break the json response
        error_reporting(E_ERROR);

        $user = Factory::getApplication()->getIdentity();

        // Only admin access and ACL check
        if (!Factory::getApplication()->isClient('administrator') || !$user->authorise('core.admin', 'com_virtuemart')) {
            $response = new \stdClass();
            $response->status        = Authentication::STATUS_FAILURE;
            $response->error_message = Text::_('JLIB_RULES_NOT_ALLOWED');
            return json_encode($response);
        }

        $input = Factory::getApplication()->input;
        $deletedIds = [];
        $virtuemart_custom_id = $input->get('virtuemart_custom_id', 0, 'INT');
        if($virtuemart_custom_id) {
            $parentPlugin = $input->get('parentPlugin', '', 'cmd');
            $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);
            $value_id =  $input->get('value_id', 0, 'INT');
            $deletedIds = $customfield->delete([$value_id]);
        }
        return json_encode(['Deleted Value Ids' => reset($deletedIds)]);
    }

    /**
     * Order the value
     *
     * @return false|string
     * @throws Exception
     * @since 2.0.0
     */
    public function onAjaxOrderCustomValue()
    {
        // Do not throw warnings and notices. They break the json response
        error_reporting(E_ERROR);

        $user = Factory::getApplication()->getIdentity();

        // Only admin access and ACL check
        if (!Factory::getApplication()->isClient('administrator') || !$user->authorise('core.admin', 'com_virtuemart')) {
            $response = new \stdClass();
            $response->status        = Authentication::STATUS_FAILURE;
            $response->error_message = Text::_('JLIB_RULES_NOT_ALLOWED');
            return json_encode($response);
        }

        $result = false;
        $input = Factory::getApplication()->input;
        $virtuemart_custom_id = $input->get('virtuemart_custom_id', 0, 'INT');
        if($virtuemart_custom_id) {
            $parentPlugin = $input->get('parentPlugin', '', 'cmd');
            $customfield = Customfield::getInstance($virtuemart_custom_id, $parentPlugin);
            $value_id =  $input->get('value_id', 0, 'INT');
            $newPosition = $input->get('newposition', 0, 'INT');
            $prevPosition = $input->get('prevposition', 0, 'INT');
            $result = $customfield->setValueOrder($value_id, $newPosition, $prevPosition);
        }
        return json_encode(['result' => $result]);
    }
}