<?php
/**
 * @package     CustomfieldsforallBasebase
 * @copyright   Copyright (C)2022 - 2023 breakdesigns.net . All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

require_once __DIR__ . '/../bootstrap.php';

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;
use Joomla\CMS\Language\Text;

class JFormFieldParentcustom extends FormField
{

    protected $type = 'customvalues';

    protected function getInput()
    {
        $jinput = Factory::getApplication()->input;
        $parents = $this->getParentCustoms();
        $renderFields = new RenderFields;
        $html = $renderFields->fetchParentCustom($this->name, $parents, $this->value);

        return $html;
    }

    protected function getLabel()
    {
        $title = '';
        if (empty($this->value)) {
            $title = '<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']);
        }
        $html = '<label data-original-title="<strong>' . Text::_($this->element['label']) . '</strong><br />' . Text::_($this->element['description']) . '" id="params_display_type-lbl" for="params_' . $this->element['name'] . '" class="hasTooltip" title="' . $title . '">' . Text::_($this->element['label']) . '</label>';

        return $html;
    }

    /**
     * Get the custom fields from the db
     * @return array
     */
    protected function getParentCustoms()
    {
        $jinput = Factory::getApplication()->input;
        $virtuemart_custom_id = $jinput->get('virtuemart_custom_id', array(), 'ARRAY');
        if (is_array($virtuemart_custom_id)) {
            $virtuemart_custom_id = end($virtuemart_custom_id);
        }

        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')->from('#__virtuemart_customs')->where('custom_element=\'dependentcustomfieldsforall\'')->order('custom_title');
        if (!empty($virtuemart_custom_id)) {
            $query->where('virtuemart_custom_id!=' . (int)$virtuemart_custom_id);
        }
        $db->setQuery($query);
        $results = $db->loadObjectList();

        return $results;
    }
}
