<?php
/**
 * @package        CustomfieldsforallBasebase
 * @copyright      Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license        GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

?>
<select
        name="<?php echo $fieldNamePrefix?>[parent_id]"
        class="cf_parent_select"
        data-custom-id="<?= $customfieldParent->getCustomId()?>"
        data-parent-plugin="<?= $customfieldParent->getPluginName();?>">
    <option value=""><?php echo Text::_('PLG_CUSTOMSFORALL_SELECT_PARENT')?></option>
    <?php
    foreach ($parent_options as $opt):
        $selected = '';
        if(isset($obj) && $obj->parent_id == $opt->customsforall_value_id):
            $selected='selected';
        endif;?>

        <option value="<?php echo $opt->customsforall_value_id?>" <?php echo $selected?>><?php echo htmlspecialchars($opt->customsforall_value_name, ENT_QUOTES)?></option>
    <?php endforeach;?>
</select>