<?php
/**
 * @package CustomfieldsforallBasebase
 * @copyright Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Customfield;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\CustomFieldsForAllLanguageHandler;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

/**
 * The name of the field
 * @var string
 */
$fieldname;
$display_id = $row . '_' . $virtuemart_custom_id;
$ordering = 0;
$page = Factory::getApplication()->input->get('page', 0 , 'INT');
$counter =  $page && $limit ? ((int)$page - 1) * (int)$limit : 0;
$width_total = 80;
$color_wrapper_width = '450px';
/** @var  CustomFieldsForAllLanguageHandler $languageHandler*/
$languageHandler;
$languages = $languageHandler->getLanguages();
$multi_lingual = count($languages) > 1 ? true : false;
$view = Factory::getApplication()->input->get('view', '', 'STRING');
$is_custom_view = $view == 'custom' ? true : false;
$data_type = !empty($custom_params['data_type']) ? $custom_params['data_type'] : 'string';
$parent_id = isset($custom_params['parent_id']) ? $custom_params['parent_id'] : 0;
$single_entry = isset($custom_params['single_entry']) ? $custom_params['single_entry'] : false;
$customfield = Customfield::getInstance($virtuemart_custom_id);

if($view == 'custom') {
    $custom = ['virtuemart_custom_id' => $virtuemart_custom_id, 'parentCustomField' => $customfield->getPluginName()];
    Factory::getApplication()->getDocument()->addScriptOptions('cf4all.custom', $custom);
    HTMLHelper::_('script', 'system/core.js', array('version' => 'auto', 'relative' => true));
    HTMLHelper::_('script', 'plg_ajax_customfieldsforall/ajax.js', array('version' => 'auto', 'relative' => true));
}
?>

<ul id="cf_values_wrapper<?php echo $display_id?>" class="sortable cf_values_wrapper" style="clear: both; list-style: none; padding: 0 1em 0 0; margin:0px;">
    <?php
    if (! empty($existing_values)) {
        foreach ($existing_values as $obj) {
            $fieldNamePrefix = 'cf_val['.$counter.']';
            $color_pallette_counter = 0;
            $pk = $obj->customsforall_value_id;
            ?>
            <li id="customsforall_value_li_<?php echo $counter ?>" style="min-width: 380px;">
                <div class="removable" style="padding: 5px 10px; background: #ededed; margin-bottom: 1em;">

                    <div class="cf4all-value-wrapper">
                        <?php if($parent_id):
                            include('customvalue_parent.php');
                        endif;?>
                        <?php
                        //colors
                        if (! empty($custom_params) && $data_type == 'color_hex') {
                            $custom_values = explode('|', $obj->customsforall_value_name);
                            $no_values = count($custom_values);
                            $width = $width_total / $no_values;
                            ?>

                            <div class="cf4all-color-value-wrapper" id="color-value-wrapper-<?php echo $counter ?>" style="width: <?= $color_wrapper_width?>;">
                                <?php
                                foreach ($custom_values as $key => $cf):?>
                                    <input type="text" data-jscolor="{}" name="<?php echo $fieldNamePrefix?>[customsforall_value_name][<?php echo $key?>]"
                                           value="<?php echo $cf ?>" class="<?php echo $class ?>" style="width:<?php echo $width ?>%; box-sizing:border-box; height:1.7rem;"/>
                                <?php endforeach;?>
                            </div>

                            <div class="cf4all-number-values-wrapper jgrid" id="number-values-wrapper-<?php echo $counter?>">
                                <input type="text" name="cf4all-number-values_<?php echo $counter?>"
                                       id="cf4all-number-values_<?php echo $counter?>" value="<?php echo $no_values ?>" size="2" disabled />
                                <span style="display: inline-block; cursor: pointer; min-width: 13px;" class="cf4all-incdec uparrow"><i class="icon-arrow-up">&nbsp&nbsp&nbsp</i></span>
                                <span style="display: inline-block; cursor: pointer; min-width: 13px;" class="cf4all-incdec downarrow"><i class="icon-arrow-down">&nbsp&nbsp&nbsp</i></span>
                            </div>
                            <?php
                            $field_name = '[customsforall_value_label]';


                            if($multi_lingual) {
                                foreach ($languages as $language) {
                                    if(!isset($language->default)) {
                                        $fieldNamePrefixLang = $fieldNamePrefix.'['.$language->lang_code.']';
                                    }
                                    else {
                                        $fieldNamePrefixLang = $fieldNamePrefix;
                                    }
                                    $field_nameLang = $fieldNamePrefixLang.$field_name;
                                    $flag_image = $language->image;
                                    $translation = $languageHandler->__($obj, $language->lang_code, $group ='label', $withId=true);
                                    $translation_value = $translation['string'];
                                    $translation_id = $translation['id'];
                                    ?>
                                    <div class="input-prepend" style="width: 75%;">
                                        <span class="cf-add-on"><img src="<?php echo $flag_image?>" alt="<?php echo $language->lang_code?>" /></span>
                                        <input style="width: 72%;" type="text" name="<?php echo $field_nameLang?>" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_LABEL')?>" value="<?php echo $translation_value?>" class="cf_value_label" />
                                        <input type="hidden" name="<?php echo $fieldNamePrefix?>[id]" value="<?php echo $translation_id ?>" />
                                    </div>
                                    <?php
                                }
                            }
                            else {
                                //no multi-lingual?>
                                <input style="width: calc(<?= $color_wrapper_width?> * (<?= $width_total - 3?>/100));" type="text" name="<?php echo $fieldNamePrefix?><?php echo $field_name?>" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_LABEL')?>"
                                       value="<?php echo $obj->customsforall_value_label?>" class="cf_value_label" />
                                <?php
                            }
                        } else {
                            $field_name = '[customsforall_value_name]';

                            //display multi-lingual only for strings
                            if($data_type == 'string' && $multi_lingual) {
                                foreach ($languages as $language) {
                                    if(!isset($language->default)) {
                                        $fieldNamePrefixLang = $fieldNamePrefix.'['.$language->lang_code.']';
                                    } else {
                                        $fieldNamePrefixLang = $fieldNamePrefix;
                                    }
                                    $field_nameLang = $fieldNamePrefixLang. $field_name;
                                    $flag_image = $language->image;
                                    $translation = $languageHandler->__($obj, $language->lang_code, $group ='value', $withId=true);
                                    $translation_value = $translation['string'];
                                    $translation_id = $translation['id'];
                                    ?>
                                    <div class="input-prepend" style="width: 75%;">
                                        <span class="cf-add-on"><img src="<?php echo $flag_image?>" alt="<?php echo $language->lang_code?>" /></span>
                                        <input type="text" style="width: 94%" name="<?php echo $field_nameLang?>" value="<?php echo $translation_value; ?>" class="<?php echo $class?>" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_VALUE')?>"/>
                                        <input type="hidden" name="<?php echo $fieldNamePrefixLang?>[id]" value="<?php echo $translation_id ?>" />
                                    </div>
                                    <?php
                                }
                            }
                            //No string or no multi-lingual
                            else {?>
                                <input style="width: 75%;" type="text" name="<?php echo $fieldNamePrefix?><?php echo $field_name?>" value="<?php echo $obj->customsforall_value_name?>"
                                       class="<?php echo $class ?>" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_VALUE')?>"/>
                                <?php
                            }
                        }?>
                        <input type="hidden" name="<?php echo $fieldNamePrefix?>[customsforall_value_id]" value="<?php echo $obj->customsforall_value_id ?>" />
                        <div class="cf_status_icon" style="display: inline-block; width:1.3rem; margin-inline-start: 1rem; font-size: 1.3rem;">
                            <span class="icon-checkmark" style="display:none; color:#98dc89; user-select: none;"></span>
                            <span class="icon-cancel"  style="display:none; color:#f59696; user-select: none;"></span>
                        </div>
                        <div class="cf-icons" style="display: inline-block; margin-top: 8px; float:right;">
                            <span class="vmicon icon-move customsforall_move_btn"></span>
                            <a href="#" class="vmicon icon-trash customsforall_delete_btn" style="color:#ed5413" data-row_id="<?php echo $counter?>" title="<?php echo Text::_('PLG_CUSTOMSFORALL_DELETE')?>"></a>
                        </div>
                    </div>
                </div>
            </li>
            <?php
            $ordering = $obj->ordering;
            $counter ++;
        }
    }
    ?>
</ul>
<?php if (!empty($virtuemart_custom_id)) {?>
    <button id="cf_newvalue_btn<?php echo $display_id?>" class="btn btn-secondary btn-sm" type="button"><?php echo Text::_('PLG_CUSTOMSFORALL_NEW_VALUE')?></button>
<?php } else { ?>
    <div class="alert alert-info"><?php echo Text::_('PLG_CUSTOMSFORALL_SAVE_BEFORE_ADDING_VALUES_LABEL'); ?></div>
    <?php
}?>

<?php if (! empty($existing_values) && count($existing_values) == $limit) {?>
    <div></div>
    <button id="cf_loadmore_btn<?php echo $display_id?>" class="cf_loadmore_btn btn btn-secondary btn-sm w-100 d-block mt-1" type="button" style="width: 100%; margin-top: 1rem;"><?php echo Text::_('PLG_CUSTOMSFORALL_LOAD_MORE')?></button>
    <div class="cf_loadmore_loader hide d-none">
        <div class="cf_dot"></div>
        <div class="cf_dot"></div>
        <div class="cf_dot"></div>
    </div>
    <?php
} ?>

<script type="text/javascript" id="cf4All_values_<?= $page?>">
    jQuery(function($){

        is_added_<?php echo $display_id?>=false;
        $("#cf_values_wrapper<?php echo $display_id?>").delegate("a.customsforall_delete_btn","click",function(event){
            event.preventDefault();
            this.closest('li').remove();
            is_added_<?php echo $display_id?>=false;
            return false;
        });

        if(typeof counter == 'undefined') {
            var counter;
        }
        counter=<?php echo $counter?>;

        $("#cf_newvalue_btn<?php echo $display_id?>").click(function(){
            <?php
            if (! $is_custom_view && (boolean) $single_entry) {?>
            if(!is_added_<?php echo $display_id?>){
                <?php
                }?>
                <?php if ($page <= 1) { ?>
                fieldNamePrefix = '<?php echo $fieldname?>['+counter+']';
                var elem_appended='\
     <li id="customsforall_value_li_' + counter + '_new" style="min-width:380px;">\
     <div class="removable" style="padding:5px 10px; background:#ededed; margin-bottom:1em;">\
     <div class="cf4all-value-wrapper">';

                <?php
                if(!empty($parent_id)):
                //reset the parent value, so that the parent list has no default selection.
                if(isset($obj)) {
                    $obj->parent_id = 0;
                }
                $fieldNamePrefix = '\'+fieldNamePrefix+\'';
                ob_start();
                include('customvalue_parent.php');
                $parent_select = ob_get_contents();
                $parent_select = trim(preg_replace('/\s+/', ' ', $parent_select));
                ob_end_clean();
                ?>
                elem_appended+='\<?php echo $parent_select?>';
                <?php endif;

                if ($data_type != 'color_hex') {
                if($data_type == 'string' && $multi_lingual) {
                foreach ($languages as $language) {
                if(isset($language->default)) {
                ?>
                fieldNamePrefix = '<?php echo $fieldname?>['+counter+']';
                <?php
                }else {
                ?>
                fieldNamePrefix = '<?php echo $fieldname?>['+counter+'][<?php echo $language->lang_code?>]';
                <?php
                }
                $flag_image = $language->image;
                ?>
                elem_appended+='\
                        <div class="input-prepend" style="width:75%;">\
                            <span class="cf-add-on"><img src="<?php echo $flag_image?>" alt="<?php echo $language->lang_code?>"/></span>\
                            <input type="text" style="width:94%" name="'+fieldNamePrefix+'[customsforall_value_name]" value="" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_VALUE')?>" class="<?php echo $class?>"/>\
                            <input type="hidden" name="'+fieldNamePrefix+'[id]" value=""/>\
                        </div>';
                <?php
                }
                }
                //is not multi-lingual or not string
                else {?>
                elem_appended+='\
                         <input style="width:75%;" type="text" name="<?php echo $fieldname?>['+counter+'][customsforall_value_name]" value="" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_VALUE')?>" class="<?php echo $class ?>"/>';

                <?php }?>
                elem_appended+='\
                 <input type="hidden" name="<?php echo $fieldname?>['+counter+'][customsforall_value_id]" value="0"/>\
                 <div class="cf_status_icon" style="display: inline-block; width:1.3rem; margin-inline-start: 1rem; font-size: 1.3rem;">\
                    <span class="icon-checkmark" style="display:none; color:#98dc89; user-select: none;"></span>\
                    <span class="icon-cancel"  style="display:none; color:#f59696; user-select: none;"></span>\
                 </div>\
                 <div class="cf-icons" style="display: inline-block; margin-top: 8px; float:right;">\
                 <span class="vmicon icon-move customsforall_move_btn"></span>\
                 <a href="#" class="vmicon icon-trash customsforall_delete_btn" style="color:#ed5413" alt="<?php echo Text::_('PLG_CUSTOMSFORALL_DELETE')?>"></a>\
                 </div>\
                </div>\
                </div>\
                </li>';
                <?php }
                else {?>
                elem_appended+='\
            <div class="cf4all-color-value-wrapper" id="color-value-wrapper-'+counter+'" style="width:450px;">\
                <input type="text" name="<?php echo $fieldname?>['+counter+'][customsforall_value_name][]" value="" class="<?php echo $class?>" id="cf_value_input<?php echo $display_id ?>'+counter+'" style="width:<?php echo $width_total ?>%; box-sizing:border-box; height:1.7rem;"/>\
            </div>\
            <div class="cf4all-number-values-wrapper jgrid" id="number-values-wrapper-'+counter+'">\
            <input type="text" name="cf4all-number-values_'+counter+'" id="cf4all-number-values_'+counter+'" value="1" size="2" disabled/>\
            <span style="display:inline-block; cursor:pointer; min-width:13px;" class="cf4all-incdec uparrow">\
            <i class="icon-arrow-up">&nbsp&nbsp&nbsp</i></span>\
            <span style="display:inline-block; cursor:pointer; width:13px;" class="cf4all-incdec downarrow">\
            <i class="icon-arrow-down">&nbsp&nbsp&nbsp</i></span>\
            </div>';
                <?php
                if($multi_lingual) {

                foreach ($languages as $language) {
                if (isset($language->default)) {?>
                fieldNamePrefix = '<?php echo $fieldname?>['+counter+']';
                <?php
                } else {?>
                fieldNamePrefix = '<?php echo $fieldname?>['+counter+'][<?php echo $language->lang_code?>]';
                <?php
                }
                $flag_image = $language->image;?>
                elem_appended+='\
                    <div class="input-prepend" style="width:75%;">\
                        <span class="cf-add-on"><img src="<?php echo $flag_image?>" alt="<?php echo $language->lang_code?>"/></span>\
                        <input type="text" style="width:94%" name="'+fieldNamePrefix+'[customsforall_value_label]" value="" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_LABEL')?>" class="cf_value_label" id="cf_label_input<?php echo $display_id ?>'+counter+'"/>\
                    </div>';
                <?php
                }
                }else {?>
                elem_appended+='\
            <input style="width: calc(<?= $color_wrapper_width?> * (<?= $width_total - 3?>/100));" type="text" name="<?php echo $fieldname?>['+counter+'][customsforall_value_label]" value="" placeholder="<?php echo Text::_('PLG_CUSTOMSFORALL_NEW_LABEL')?>" class="cf_value_label" id="cf_label_input<?php echo $display_id ?>'+counter+'"/>';
                <?php }?>

                elem_appended+='\
            <input type="hidden" name="<?php echo $fieldname?>['+counter+'][customsforall_value_id]" value="0"/>\
            <div class="cf_status_icon" style="display: inline-block; width:1.3rem; margin-inline-start: 1rem; font-size: 1.3rem;">\
                <span class="icon-checkmark" style="display:none; color:#98dc89; user-select: none;"></span>\
                <span class="icon-cancel"  style="display:none; color:#f59696; user-select: none;"></span>\
            </div>\
            <div class="cf-icons" style="display: inline-block; margin-top: 8px; float:right;">\
            <span class="vmicon icon-move customsforall_move_btn"></span>\
            <a href="#" class="vmicon icon-trash customsforall_delete_btn" style="color:#ed5413" alt="<?php echo Text::_('PLG_CUSTOMSFORALL_DELETE')?>"></a>\
            </div>\
            </div>\
            </div>\
            </li>';
                <?php }?>
                $("#cf_values_wrapper<?php echo $display_id?>").append(elem_appended);
                is_added_<?php echo $display_id?>=true;
                let CfWrapper = document.getElementById('customsforall_value_li_' + counter + '_new').querySelector('.cf4all-value-wrapper');
                if(typeof CF4All != 'undefined') {
                    CF4All.Customvalues.addEventListenerOnElements(CfWrapper);
                }
                <?php } ?>

                <?php
                if ($data_type == 'color_hex') {?>
                const colorInputs = CfWrapper.querySelectorAll('input.color:not(.jscolor)');
                colorInputs.forEach((colorInput) => {
                    new JSColor(colorInput, {});
                });
                <?php }?>
                counter++;
                <?php
                if(!empty($parent_id)){?>
                jQuery(function($) {

                    /* JS Select2 */
                    jQuery(".cf_parent_select:not(.select2-hidden-accessible)").select2({
                            ajax: {
                                url: 'index.php?option=com_ajax&tmpl=component&view=custom&plugin=getCustomValues&format=json&',
                                data: function (params) {
                                    let query = {
                                        virtuemart_custom_id: $(this).attr('data-custom-id'),
                                        parentPlugin: $(this).attr('data-parent-plugin'),
                                        search: params.term,
                                        page: params.page || 1
                                    }

                                    /* Query parameters will be ?search=term&page=number */
                                    return query;
                                },
                                processResults: function (data, params) {
                                    params.page = params.page || 1;
                                    data = JSON.parse(data.data);
                                    return data;
                                }
                            }
                        }
                    );

                    /* We execute this later because otherwise the chosen will be executed after that script */
                    setTimeout(() => {
                        /* Destroy chosen if exists (Does not work so far) */
                        jQuery(".cf_parent_select.chzn-done").chosen("destroy");
                        jQuery(".cf_parent_select.chzn-done").show().removeClass('chzn-done');
                    }, 1000)

                });
                <?php
                }
                ?>
                <?php
                if (! $is_custom_view && $single_entry) {?>
            }
            <?php }?>
            return false
        });
        jQuery("#cf_values_wrapper<?php echo $display_id?>").sortable({handle: ".customsforall_move_btn"});
        <?php
        if ($data_type == 'color_hex') {
        // Install the JS color pane to the inputs loaded in the next pages
        if((int)$page > 1) {?>
        JSColor.install('.cf_values_wrapper');
        <?php
        }
        // Load that just once (because of delegate)
        if((int)$page <= 1) {?>
        $("#cf_values_wrapper<?php echo $display_id?>").delegate("span.cf4all-incdec", "click",function(){
            const $button = $(this);
            const parentColorInputsWrapper = $button.closest('.cf4all-value-wrapper').find('.cf4all-color-value-wrapper');
            let counter=($button.parent().attr("id").match(/\d+$/));
            let oldValue = parseInt($button.parent().find("input").val());
            let newValue = 1;

            if($button.hasClass("uparrow")){
                newValue=oldValue+1;
                let newColorInput = document.createElement('input');
                newColorInput.type ="text";
                newColorInput.name = '<?php echo $fieldname?>['+counter+'][customsforall_value_name][]';
                newColorInput.className = "<?php echo $class ?>";
                newColorInput.id = 'cf_value_input_new<?php echo $display_id?>'+counter+'_'+newValue;
                newColorInput.style = "width:<?php echo $width_total ?>%; box-sizing:border-box; height:1.7rem;";
                parentColorInputsWrapper.append(newColorInput);
                new JSColor(newColorInput, {});
                let event = new CustomEvent("addedColorInput", {bubbles: false, detail: {wrapper: $button.closest('.cf4all-value-wrapper').get( 0 )}});
                document.dispatchEvent(event);
            }else if(oldValue>1){
                newValue=oldValue-1;
                parentColorInputsWrapper.find(".color:last-child").remove();
                let event = new CustomEvent("removedColorInput", {bubbles: false, detail: {wrapper: $button.closest('.cf4all-value-wrapper').get( 0 )}});
                document.dispatchEvent(event);
            }else{newValue=1}
            $button.parent().find("input").val(newValue);
            return true;
        });
        <?php }
        }
        if(!empty($parent_id)){?>
        jQuery(function($) {

            /* JS Select2 */
            jQuery(".cf_parent_select:not(.select2-hidden-accessible)").select2({
                    ajax: {
                        url: 'index.php?option=com_ajax&tmpl=component&view=custom&plugin=getCustomValues&format=json&',
                        data: function (params) {
                            let query = {
                                virtuemart_custom_id: $(this).attr('data-custom-id'),
                                parentPlugin: $(this).attr('data-parent-plugin'),
                                search: params.term,
                                page: params.page || 1
                            }

                            /* Query parameters will be ?search=term&page=number */
                            return query;
                        },
                        processResults: function (data, params) {
                            params.page = params.page || 1;
                            data = JSON.parse(data.data);
                            return data;
                        }
                    }
                }
            );

            /* We execute this later because otherwise the chosen will be executed after that script */
            setTimeout(() => {
                /* Destroy chosen if exists (Does not work so far) */
                jQuery(".cf_parent_select.chzn-done").chosen("destroy");
                jQuery(".cf_parent_select.chzn-done").show().removeClass('chzn-done');
            }, 1000)

        });
        if(typeof cf_css_dropdown == "undefined") {
            const style = `
                 /* Hide chosen */
                .cf4all-value-wrapper .chzn-container, .cf4all-value-wrapper .chosen-container{
                    display: none;
                }
                .cf4all-value-wrapper .select2-container {
                    display: block;
                    margin-bottom: 1rem;
                }
                .select2-container .select2-search--dropdown .select2-search__field {
                   height: auto;
                }
                `;
            let styleEl = document.createElement('style');
            styleEl.textContent = style;
            styleEl.id = 'cf4AllValuesCss'
            document.querySelector('head').appendChild(styleEl);
            cf_css_dropdown = true;
        }
        <?php
        }
        ?>
    });
</script>
