<?php
/**
 * @package DependentCustomfieldsforall
 * @copyright   Copyright (C)2014-2023 breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\CustomfieldsForAllFilter;
use Breakdesigns\Plugin\System\Customfieldsforallbase\RenderFields;

/** @var  ProductRow $block */
$block = new ProductRow($this->_name, $product_id, $field->virtuemart_custom_id);

/** @var  CustomfieldsForAllFilter $filterInput */
$filterInput = CustomfieldsForAllFilter::getInstance();
$custom_params = $block->getCustomParams();
$datatype = $custom_params['data_type'];
$virtuemart_customfield_id = isset($field->virtuemart_customfield_id) ? $field->virtuemart_customfield_id : 0;
$product_values = $block->getProductValues($virtuemart_customfield_id);
$product_value_ids = array_keys($product_values);

/** @var array $values_obj_list */
if($datatype == 'color_hex') {
    $values_obj_list = $block->getCustomValues();
}else {
    // Load only the selected. The rest will be be loaded through ajax during selection.
    $values_obj_list = $product_values;
}

//load scripts and styles
$block->getCustom()->loadStylesScripts();

$option_style = '';
$selected = '';
$multiple = '';
if (!$custom_params['is_price_variant'] && (!isset($force_multiple) || $force_multiple == true)) {
    $multiple = 'multiple';
}

//Non color types
if ($datatype != 'color_hex') {
    include __DIR__ . DIRECTORY_SEPARATOR . 'productRow_select.php';
} //color buttons
else {
    include __DIR__ . DIRECTORY_SEPARATOR . 'productRow_colors.php';
}

//create also new values using the existing JElement

$renderFields = new RenderFields;
$custom_params['single_entry'] = empty($multiple) ? true : false;
$addValues_el = $renderFields->fetchCustomvalues($name = $this->_product_paramName . '[' . $row . ']' . $field_prefix . '['.$this->_name.'][newvalues]',
    $block->getVirtuemartCustom_id(), $value = '', $row, $custom_params);
echo $addValues_el;
?>
<input type="hidden" name="<?= $this->_product_paramName?>[<?= $row?>]<?= $field_prefix?>[<?= $this->_name;?>][virtuemart_custom_id]" value="<?= $block->getVirtuemartCustom_id()?>"/>
<input type="hidden" name="<?= $this->_product_paramName?>[<?= $row?>]<?= $field_prefix?>[<?= $this->_name;?>][row]" value="<?= $row?>"/>
