<?php
/**
 * @package customfieldsforall
 * @copyright Copyright (C)2014-2023 https://breakdesigns.net . All rights reserved.
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\CustomfieldsForAllFilter;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Language\CustomFieldsForAllLanguageHandlerFactory;
use Breakdesigns\Plugin\System\Customfieldsforallbase\Model\Customfield;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$document = Factory::getDocument();
$document->addStyleSheet(Uri::root(true) . '/plugins/system/customfieldsforallbase/view/frontend/css/style.css');
/** @var Customfield $customfield */
$customfield = Customfield::getInstance($viewData->productCustom->virtuemart_custom_id,
    $viewData->productCustom->custom_element);
$custom_params = $customfield->getCustomfieldParams();
$languageHandlerFactory = new CustomFieldsForAllLanguageHandlerFactory();
$languageHandler = $languageHandlerFactory->get();
// no values no preview
if (empty($viewData->values)) {
    return false;
}
?>

<span class="product-field-wrapper">
    <?php
    // The title in some pages (e.g. products, is generated by the VM layouts)
    if(!empty($viewData->productCustom->custom_title) && $viewData->showTitle) {?>
        <span class="product-field-label"><?php echo Text::_($viewData->productCustom->custom_title); ?>: </span>
        <?php
    }
    $count = 0;
    foreach ($viewData->values as $key => $value) {
        // in cart/order we pass the value_product_id
        if(is_scalar($value)) {
            $customValue = Customfield::getCustomValue(0, 0, $value);
        }
        // in product/category we pass the custom value object
        else {
            $customValue = Customfield::getCustomValue($value->customsforall_value_id);
        }

        \vmdebug('Cf4All Values:', $customValue);
        if(!$customValue) {
            continue;
        }

        $outside_label = '';
        $style = '';
        $class = '';
        if ($custom_params['display_type'] == 'color' || $custom_params['display_type'] == 'color_multi') {
            $custom_value_name_multi = explode('|', $customValue->customsforall_value_name);
            $count_multi_values = count($custom_value_name_multi);
            $width = 100 / $count_multi_values;
            $min_width = '0.8em';
            $label_html = '';

            foreach ($custom_value_name_multi as $custom_value_name) {
                // validate hex color values
                $color = CustomfieldsForAllFilter::getInstance()->checkNFormatColor($custom_value_name);
                if ($color === false) {
                    return false;
                }

                /**
                 * This is a stupid hack we have to use for setting width to the spans in TCPDF
                 * It ignores any width style of the elements.
                 * Also by using divs, it shows them full width.
                 * Seems like the only workaround is to use spans and define their width by using content inside them
                 */
                $inlineContent = '';
                if ($viewData->pdf) {
                    // str_pad can take a single character. hence we pass ~ and we replace it with '&nbsp;'
                    $inlineContent = str_replace('~', '&nbsp;', str_pad('', (int)10 / $count_multi_values, '~'));
                }
                $label_style = 'background-color:' . $color . '; height:1em; min-width:' . $min_width . '; width:' . $width . '%; display:inline-block';
                $label_html .= '<span class="cf4all_inner_value" style="' . $label_style . '"> ' . $inlineContent . '</span>';
            }

            // Set inline css, when the values are shown outside the plugin's scope. e.g. Admin Order Page
            if (Factory::getApplication()->isClient('administrator')) {
                $style = 'style="height: 1em; font-weight: 500; border: 1px solid #474949; color:#ffffff; text-shadow:-1px 1px #444444; display:block; width:40px"';
            }

            if (!empty($customValue->customsforall_value_label)) {
                $outside_label = $languageHandler->__($customValue, $lang = '', $group = 'label');
                if ($count_multi_values == 1 && !$viewData->pdf) {
                    $outside_label .= '(' . $customValue->customsforall_value_name . ')';
                }
            } else {
                $outside_label = '(' . $languageHandler->__($customValue) . ')';
            }
            $class = ' cf4all_color_btn';
            $class .= Factory::getApplication()->input->get('view') == 'productdetails' ? ' cf4all_color_btn_medium' : ' cf4all_color_btn_small';
            $label = $label_html;
        } else {
            $label = $languageHandler->__($customValue);
            while (!empty($customValue->parent_id)) {
                $option_parent = Customfield::getCustomValue($customValue->parent_id);
                $label = $languageHandler->__($option_parent) . ' - ' . $label;
                $customValue = $option_parent;
            }
        } ?>
        <span id="cf4all_option_<?php echo $customValue->customsforall_value_id ?>"
              class="cf4all_option<?php echo $class ?>"  <?php echo $style ?>><?php echo $label ?></span><?php
        if (Factory::getApplication()->isClient('administrator') && $outside_label) {?>
            <span class="cf4all_outside_label"><?php echo $outside_label?></span>
            <?php
        }
        if (count($viewData->values) > $count + 1 && $custom_params['display_type'] != 'color' && $custom_params['display_type'] != 'color_multi' && isset($viewData->separator)) {
            ?><span class="cf4all_comma"><?php echo $viewData->separator?></span><?php
        }
        $count++;
    }
    ?>
</span>

