<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldGFontSubsets extends JFormFieldList
{
	protected $type = 'GFontSubsets';

	protected function getOptions()
	{
		$options = parent::getOptions();
		$parent  = !empty($this->element['parent']) ? (string) $this->element['parent'] : null;
		$form    = new JRegistry($this->form->getValue('params'));
		
		if (empty($parent))
		{
			return $options;
		}
		
		if (version_compare(JVERSION, '4.0.0', 'ge') && $this->multiple)
		{
			$this->layout = 'joomla.form.field.list-fancy-select';
		}

		JHtml::_('jquery.framework');
		
		$doc = JFactory::getDocument();
		$token = JSession::getFormToken();
		$doc->addScriptDeclaration("
			jQuery(document).ready(function($) {
				$('.{$parent}').on('change', function() {
					var form = $(this).parents('form');
					var url = form.attr('action');
					var font_name = $(this).val();
					$('#{$this->id}').html('');
					$.ajax({
						type: 'GET',
						dataType: 'JSON',
						url: url,
						data: {
							'task': 'style.getGoogleFont',
							'font_name': encodeURIComponent(font_name),
							'{$token}': 1
						},
						success: function(e) {
							if (e.error) {
								VPFramework.showMessage(e.msg, 'red');
							}
							if (e.redirect) {
								window.location.replace(e.redirect);
							} else if (e.reload) {
								window.location.reload();
							}
							if (!e.msg.subsets) {
								$('#{$this->id}').trigger('liszt:updated');
								return false;
							}
							var options = '';
							var selected = '';
							var name;
							$.each(e.msg.subsets, function(index, value) {
								selected = (value == 'latin') ? ' selected' : '';
								name = value.replace('-ext', ' Extended');
								options += '<option value=\"' + value + '\"' + selected + '>' + $.ucwords(name) + '</option>';
							});
							$('#{$this->id}').html(options);
							$('#{$this->id}').trigger('liszt:updated');
						},
						error: function(e, f, g) {
							console.log(e);
							console.log(f);
							console.log(g);
							$('#{$this->id}').trigger('liszt:updated');
						}
					});
					
				});
			})
		");
		
		$helper = VPFrameworkAdmin::getInstance();
		$selectedFont = $form->get($parent, '');
		
		if (empty($selectedFont))
		{
			$fonts = $helper->getGoogleFonts(false);
			
			if (empty($fonts))
			{
				return $options;
			}
			
			$selectedFont = $fonts[0]['family'];
		}
		
		$font = $helper->getGoogleFont($selectedFont, false);
		
		if (empty($font))
		{
			return $options;
		}
		
		$items = !empty($font['subsets']) ? $font['subsets'] : array();
		
		foreach ($items as $item)
		{
			$name = str_replace('-ext', ' Extended', $item);
			$options[] = JHtml::_('select.option', $item, ucwords($name));
		}
		
		return $options;
	}
}