<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class JFormFieldGroupHeading extends JFormField
{
	protected $type = 'GroupHeading';

	function getInput()
	{
		$class = isset($this->element['class']) ? ' ' . $this->element['class'] : '';
		$html = '<h4 class="vpf-group-heading' . $class . '"><span>' . $this->element['label'] . '</span></h4>';
		if (isset($this->element['description']))
		{
			$html .= '<div class="vpf-group-heading-desc' . $class . '"><span class="small muted">' . $this->element['description'] . '</span></div>';
		}
		return $html;
	}
}