<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\Component\Modules\Administrator\Helper\ModulesHelper;
use Joomla\Component\Modules\Administrator\Service\HTML\Modules;

class JFormFieldModPositions extends JFormField
{
	protected $type = 'ModPositions';

	function getInput()
	{
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			JHtml::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_modules/src/Service/HTML/Modules.php');
			
			// Load language files
			$language = JFactory::getLanguage();
			// Loads the current language-tag
			$language_tag = $language->getTag(); 
			$language->load('com_modules', JPATH_ADMINISTRATOR, $language_tag, true);

			$clientId          = 0;
			$state             = 1;
			$selectedPosition  = $this->value;
			$modules           = new Modules;
			$positions         = $modules->positions($clientId, $state, $selectedPosition);

			// Add custom position to options
			$customGroupText = JText::_('COM_MODULES_CUSTOM_POSITION');

			JFactory::getDocument()->getWebAssetManager()
				->usePreset('choicesjs')
				->useScript('webcomponent.field-fancy-select');

			// Build field
			$attr = array(
				'id'          => $this->id,
				'list.select' => $this->value,
				'list.attr'   => 'class="chzn-custom-value" '
				              . 'data-custom_group_text="' . $customGroupText . '" '
				              . 'data-no_results_text="' . JText::_('COM_MODULES_ADD_CUSTOM_POSITION') . '" '
				              . 'data-placeholder="' . JText::_('COM_MODULES_TYPE_OR_SELECT_POSITION') . '" '
			);
			
			$html  = '<joomla-field-fancy-select class="" allow-custom placeholder="' . JText::_('COM_MODULES_TYPE_OR_SELECT_POSITION') . '" search-placeholder="' . JText::_('COM_MODULES_TYPE_OR_SELECT_POSITION') . '" >';
			$html .= JHtml::_('select.groupedlist', $positions, $this->name, $attr);
			$html .= '</joomla-field-fancy-select>';
		}
		else
		{
			require_once JPATH_ADMINISTRATOR . '/components/com_templates/helpers/templates.php';
			
			if (!class_exists('ModulesHelper'))
			{
				require_once JPATH_ADMINISTRATOR . '/components/com_modules/helpers/modules.php';
			}

			// Load language files
			$language = JFactory::getLanguage();
			$language_tag = $language->getTag(); // loads the current language-tag
			JFactory::getLanguage()->load('com_modules', JPATH_ADMINISTRATOR, $language_tag, true);

			JHtml::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_modules/helpers/html');
			
			$clientId          = 0;
			$state             = 1;
			$selectedPosition  = $this->value;
			$positions         = JHtml::_('modules.positions', $clientId, $state, $selectedPosition);

			// Add custom position to options
			$customGroupText = JText::_('COM_MODULES_CUSTOM_POSITION');

			// Build field
			$attr = array(
				'id'          => $this->id,
				'list.select' => $this->value,
				'list.attr'   => 'class="chzn-custom-value" '
				               . 'data-custom_group_text="' . $customGroupText . '" '
				               . 'data-no_results_text="' . JText::_('COM_MODULES_ADD_CUSTOM_POSITION') . '" '
				               . 'data-placeholder="' . JText::_('COM_MODULES_TYPE_OR_SELECT_POSITION') . '" '
			);
			
			$html = JHtml::_('select.groupedlist', $positions, $this->name, $attr);
		}
		
		JHtml::_('jquery.framework');
		
		$doc  = JFactory::getDocument();
		$form = new JRegistry($this->form->getValue('params'));
		
		if ($form->get('mega_subcontent') != 'pos')
		{
			$doc->addScriptDeclaration("
				jQuery(window).on('load', function(){
					jQuery('#{$this->id}').parents('.control-group ').hide();
				});
			");
		}
		
		$doc->addScriptDeclaration("
			jQuery(document).ready(function(a){
				a('#jform_params_mega_subcontent').change(function(){
					if (a(this).val() != 'pos') {
						a('#{$this->id}').parents('.control-group ').hide();
					} else {
						a('#{$this->id}').parents('.control-group ').show();
					}
				});
			});
		");

		return $html;
	}
}