<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die();

JFormHelper::loadFieldClass('list');

class JFormFieldModules extends JFormFieldList
{
	protected $type = 'Modules';
	
	protected function getOptions()
	{
		JHtml::_('jquery.framework');
		
		$doc = JFactory::getDocument();

		$doc->addScriptDeclaration("
			jQuery(document).ready(function(a){
				a(window).on('load', function(){
					jQuery('#{$this->id}').parents('.control-group ').hide();
				});
				a('#jform_params_mega_subcontent').change(function(){
					if (a(this).val() != 'mod') {
						a('#{$this->id}').parents('.control-group ').hide();
					} else {
						a('#{$this->id}').parents('.control-group ').show();
					}
				});
			});
		");
		
		if (version_compare(JVERSION, '4.0.0', 'ge') && $this->multiple)
		{
			$this->layout = 'joomla.form.field.list-fancy-select';
		}
		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true)
			->select(' e.extension_id, a.id, a.title, a.note, a.position, a.module, a.language,a.checked_out, ' .
							 'a.checked_out_time, a.published, a.access, a.ordering, a.publish_up, a.publish_down, ' .
							 'l.title AS language_title,uc.name AS editor,ag.title AS access_level, ' .
							 'MIN(mm.menuid) AS pages,e.name AS name')
			->from('#__modules AS a')
			->join('LEFT', '#__languages AS l ON l.lang_code = a.language')
			->join('LEFT', '#__users AS uc ON uc.id = a.checked_out')
			->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access')
			->join('LEFT', '#__modules_menu AS mm ON mm.moduleid = a.id')
			->join('LEFT', '#__extensions AS e ON e.element = a.module')
			->where('a.published IN (0, 1)')
			->where('a.client_id = 0')
			->group('a.id');

		$db->setQuery($query);
		$groups = $db->loadObjectList();

		$options = array();
		
		if ($groups && count($groups)) 
		{
				foreach ($groups as $v => $t) 
				{
					$options[] = JHTML::_('select.option', $t->id, $t->title);
				}
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}