<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class JFormFieldVPSortable extends JFormField
{
	protected $type = 'VPSortable';
	
	function getInput()
	{
		$doc     = JFactory::getDocument();
		$options = $this->getOptions();
		
		if (empty($options))
		{
			return '';
		}
		
		JHtml::_('jquery.framework');
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			JHtml::_('script', 'vpframework/jquery.ui.core.min.js', array('relative' => true));
			JHtml::_('script', 'vpframework/jquery.ui.sortable.min.js', array('relative' => true));
			JHtml::_('script', 'vpframework/sortablelist.js', array('relative' => true));
			
			JHtml::_('stylesheet', 'vpframework/sortablelist.css', array('relative' => true));
		}
		else
		{
			JHtml::_('jquery.ui', array('core', 'sortable'));
			JHtml::_('script', 'jui/sortablelist.js', array('relative' => true));
			
			JHtml::_('stylesheet', 'jui/sortablelist.css', array('relative' => true));
		}

		$doc->addScriptDeclaration("
		jQuery(document).ready(function($) {
			$('.vp-sortable-list').sortable({
				axis: 'y'
			});
		});
		");
		
		$doc->addStyleDeclaration("
		.vp-sortable-container,
		.vp-sortable-container * {
			-webkit-box-sizing: border-box;
			-moz-box-sizing: border-box;
			box-sizing: border-box;
		}
		.vp-sortable-container {
			border: 1px solid #aaa;
			padding: 10px 13px;
			width: 220px;
			background-color: #fff;
			background-image: -webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(1%, #eeeeee), color-stop(15%, #ffffff));
			background-image: -webkit-linear-gradient(#eeeeee 1%, #ffffff 15%);
			background-image: -moz-linear-gradient(#eeeeee 1%, #ffffff 15%);
			background-image: -o-linear-gradient(#eeeeee 1%, #ffffff 15%);
			background-image: linear-gradient(#eeeeee 1%, #ffffff 15%);
		}
		.vp-sortable-list {
			list-type: none;
			list-style-type: none;
			padding: 0;
			margin: 0;
		}
		.vp-sortable-list li {
			display: block;
			margin: 3px 0 3px;
			padding: 3px 20px 3px 5px;
			border: 1px solid #aaa;
			border-radius: 3px;
			background-color: #e4e4e4;
			background-image: -webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), color-stop(100%, #eeeeee));
			background-image: -webkit-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eeeeee 100%);
			background-image: -moz-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eeeeee 100%);
			background-image: -o-linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eeeeee 100%);
			background-image: linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eeeeee 100%);
			background-clip: padding-box;
			box-shadow: 0 0 2px white inset, 0 1px 0 rgba(0, 0, 0, 0.05);
			color: #333;
			line-height: 13px;
			cursor: move;
			cursor: grab;
			cursor: -moz-grab;
			cursor: -webkit-grab;
		}
		");
		
		$html = array();
		
		$html[] = '<div class="vp-sortable-container" id="' . $this->id . '">';
		$html[] = '<ul class="vp-sortable-list">';
		$html[] = implode($options);
		$html[] = '</ul>';
		$html[] = '</div>';
		
		return implode($html);
	}
	
	protected function getOptions()
	{
		$options = array();
		
		foreach ($this->element->xpath('option') as $option)
		{
			$value = (string) $option['value'];
			$text  = trim((string) $option) ? trim((string) $option) : $value;
			$text  = JText::_($text);
			
			$optionHtml  = '<li>';
			$optionHtml .= '<i class="icon-menu"></i>';
			$optionHtml .= '<span>' . $text . '</span>';
			$optionHtml .= '<input type="hidden" name="' . $this->name . '[]" value="' . $value . '" />';
			$optionHtml .= '</li>';
			
			$options[$value] = $optionHtml;
		}
		
		if (!empty($this->value) && is_array($this->value) && !empty($options))
		{
			$options = VPFrameworkUtility::sortArrayByArray($options, $this->value);
		}
		
		return $options;
	}
}