<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

//require_once JPATH_SITE . '/components/com_users/helpers/route.php';

JLoader::register('UsersHelperRoute', JPATH_SITE . '/components/com_users/helpers/route.php');

class VPFrameworkLogin
{
	protected static $langLoaded = false; 
	
	public static function getReturnURL($params = null, $type = null)
	{
		$app    = JFactory::getApplication();
		$router = $app->getRouter();
		$url    = null;
		
		if (is_string($params))
		{
			$url = trim($params);
		}
		elseif (!empty($params) && !empty($type) && ($itemid = $params->get($type)))
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select($db->quoteName('link'))
				->from($db->quoteName('#__menu'))
				->where($db->quoteName('published') . '=1')
				->where($db->quoteName('id') . '=' . $db->quote($itemid));

			$db->setQuery($query);

			if ($link = $db->loadResult())
			{
				if (!version_compare(JVERSION, '4.0.0', 'ge') && $router->getMode() == JROUTER_MODE_SEF)
				{
					$url = 'index.php?Itemid=' . $itemid;
				}
				else
				{
					$url = $link . '&Itemid=' . $itemid;
				}
			}
		}

		if (!$url)
		{
			// Stay on the same page
			$url = JUri::getInstance()->toString();
		}

		return base64_encode($url);
	}

	public static function getType()
	{
		if (!self::$langLoaded)
		{
			$lang = JFactory::getLanguage();
			$lang->load('com_users', JPATH_SITE, 'en-GB', false);
			$lang->load('com_users', JPATH_SITE, $lang->getDefault(), false);
			$lang->load('com_users', JPATH_SITE, null, false);
			self::$langLoaded = true;
		}
				
		$user = JFactory::getUser();
		return (!$user->get('guest')) ? 'logout' : 'login';
	}

	public static function getTwoFactorMethods()
	{
		require_once JPATH_ADMINISTRATOR . '/components/com_users/helpers/users.php';

		return UsersHelper::getTwoFactorMethods();
	}
}
