<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die;

// Load VP Framework Helper class
JLoader::register('plgSystemVPFrameworkHelper', __DIR__ . '/helper.php');

/**
* VP Framework System Plugin
* 
* @package   VP Framework
* @since     1.0.0
*/
class plgSystemVPFramework extends JPlugin 
{
	protected $app;
	
	/**
	 * Constructor.
	 *
	 * @param   object  &$subject  The object to observe
	 * @param   array   $config    An optional associative array of configuration settings.
	 *
	 * @since   1.0.0
	 */
	public function __construct(&$subject, $config)
	{
		parent::__construct ($subject, $config);
		
		$this->app = empty($this->app) ? JFactory::getApplication() : $this->app;
		
		// Register helper class autoloader
		plgSystemVPFrameworkHelper::autoloadRegister();
		
		// For Joomla 4
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$this->registerLegacyListener('plgVmBeforeProductSearch'); 
		}
	}
	
	public function onAfterInitialise()
	{
		if ($this->app->isClient('administrator'))
		{
			return;
		}
	}
	
	/**
	 * After route.
	 *
	 * @return  void
	 */
	public function onAfterRoute()
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();

		// If we do not need VP Framework do nothing
		if (!$helper->needVPF())
		{
			return;
		}

		$document = JFactory::getDocument();
		
		// If the document object is not set in the application
		if (!$this->app->getDocument())
		{
			// Set the document object in the application
			$this->app->loadDocument($document);
		}

		// Initialize framework
		$helper->initialize();

		if ($this->app->isClient('administrator'))
		{
			// Load admin template edit layout and methods
			$result = $helper->loadTemplateAdmin();
			if ($result !== null) return $result;
		}
		else
		{
			// Set VM Category Product Listing View Mode
			$helper->setVMProductListMode();

			// Prepare special framework views for display
			$helper->prepareSpecialViews();

			// Manage Module Cache where needed
			$helper->manageModuleCache();

			// Manage Breadcrumbs where needed
			$helper->manageBreadcrumbs();

			// Manage Wishlist where needed
			$helper->manageWishlist();
		}
	}
	
	/**
	 * On Ajax call of VP Framework.
	 *
	 * @return  mixed/void
	 *
	 * @since   1.4
	 */
	public function onAjaxVpframework()
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		// If we do not need VP Framework do nothing
		if ($this->app->isClient('administrator') || !$helper->needVPF())
		{
			return;
		}
		
		// Register special VPF Methods
		$result = $helper->registerVPFMethods();
		if ($result !== null) return $result;
	}

	/**
	 * Before head is compiled.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public function onBeforeCompileHead()
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('administrator') || !$helper->needVPF(true))
		{
			return;
		}
		
		// Load required inline scripts for the framework
		$helper->loadInlineAssets();
		
		// Prepare site HTML head
		$helper->prepareHead();
	}

	/**
	 * After render.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public function onAfterRender()
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('administrator') || !$helper->needVPF(true))
		{
			return;
		}
	
		// Prepare HTML body
		$helper->prepareBody();
	}

	/**
	 * Before content display.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public function onContentBeforeDisplay($context, &$article, &$params)
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('administrator') || !$helper->needVPF())
		{
			return;
		}
		
		// Display the special viewed built using Joomla! contents
		$helper->displaySpecialViews($context, $article, $params);
	}
	
	public function onExtensionBeforeSave($context, $table, $isNew)
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('site') || !$helper->needVPF())
		{
			return;
		}
		
		// Save additional form fields
		return $helper->onExtensionBeforeSave($context, $table, $isNew);
	}
	
	/**
	 * On content form preparation.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	function onContentPrepareForm($form, $data)
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if (!$helper->needVPF())
		{
			return;
		}
		
		// Add additional params to Joomla! admin forms
		$helper->addParamsToAdminForms($form, $data);
	}

	/**
	 * Called if user fails to be logged in.
	 *
	 * @param   array  $response  Array of response data.
	 *
	 * @return  void
	 *
	 * @since   1.5
	 */
	public function onUserLoginFailure($response)
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('administrator') || !$helper->needVPF(true))
		{
			return;
		}

		// Handle login failures
		$helper->onUserLoginFailure($response);
	}
	
	
	public function plgVmBeforeProductSearch(&$select, &$joinedTables, &$where, &$groupBy, &$orderBy, &$joinLang)
	{
		$helper = plgSystemVPFrameworkHelper::getInstance();
		
		if ($this->app->isClient('administrator') || !$helper->needVPF(true))
		{
			return;
		}
		
		$helper->mergeCustomFilterQuery($select, $joinedTables, $where, $groupBy, $orderBy, $joinLang);
	}
	
	/**
	 * Called on live update installation.
	 *
	 * @return  boolean
	 *
	 * @since   2.0
	 */
	public function onInstallerBeforePackageDownload(&$url, &$headers)
	{
		return VPFrameworkDlk::addDlk($url, $headers);
	}
}