/**
 * cvfind.js: General Javascript Library for VirtueMart Frontpage
 *
 * @package    VirtueMart
 * @subpackage Javascript Library
 * @authors    Max Milbers, Abhishek Das
 * @copyright  Copyright (c) 2014-2016 VirtueMart Team. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

var Virtuemart = window.Virtuemart || {};

(function($) {

	Virtuemart.findContainers = function(event) {
		var runs = 0,
			maxruns = 20,
			container = $(event.currentTarget).closest('.product-field-display'),
			containerClass = container.length && container.closest('.product-listing').length > 0 ? 'product-item' : 'vm-productdetails',
			defaultSelector = Virtuemart.containerSelector,
			targetContainer;
		
		if(container.closest('.product-comparison-page').length) {
			containerClass = 'compare-item-inner';
		}
		
		// Fallback to default VirtueMart class
		if(!$(document).find('.' + containerClass).length) {
			containerClass = 'product-container';
		}
			
		if(!container.length) {
			console.log('CV: Could not find parent container product-field-display');
			return false;
		}

		Virtuemart.container = container;

		Virtuemart.containerSelector = '.' + containerClass;
		
		targetContainer = Virtuemart.container.closest(Virtuemart.containerSelector);

		if(!targetContainer.length) {
			Virtuemart.containerSelector = defaultSelector ? defaultSelector : Virtuemart.containerSelector;
			containerClass = Virtuemart.containerSelector.substring(1);
			targetContainer = Virtuemart.container.closest(containerClass);
			
			if(!targetContainer.length) {
				console.log('CV: Could not find product-container ' + defaultSelector, container);
				return false;
			}
		} 
		
		Virtuemart.container = targetContainer;
		
		return container;
	}

	Virtuemart.cvFind = function(event) {
		event.preventDefault();
		
		var selection = [],
				container = Virtuemart.findContainers(event),
				found = false;

		//We check first if it is a radio
		$(container).find('.cvselection:checked').each(function() {
			selection[selection.length] = $(this).val();
			found = true;
		});
		
		if (!found) {
			$(container).find('.cvselection').each(function() {
				selection[selection.length] = $(this).val();
			});
		}

		var index = 0,
			i2 = 0,
			hitcount = 0;
			
		// To ensure that an url is set, set the url of first product
		$(this).prop('url', event.data.variants[0][0]);
		
		for (i = 0; i < selection.length; index++) {
			
			for (index = 0; index < event.data.variants.length; index++) {
				hitcount = 0;
				
				for (i2 = 0; i2 <= selection.length; i2++) {
					if (selection[i2] == event.data.variants[index][i2 + 1]) {
						hitcount++;
						
						if (hitcount == (selection.length - i)) {
							var url = event.data.variants[index][0].replace(/amp;/g, '');
							$(this).attr('url', url);
							$(this).val(url);
							
							if ($(this).data('reload')) {
								Virtuemart.isUpdatingContent = true;
								window.top.location.href = url;
								return false;
							}

							return url;
						}
					} else {
						break;
					}
				}
				
			}
			
			i++;
		}

		return false;
	};

	Virtuemart.avFind = function(event) {
		event.preventDefault();

		var container = Virtuemart.findContainers(event),
				url = false,
				found = false;
				console.log(container);
		$(container).find('.avselection:checked').each(function() {
			found = true;
			url = $(this).attr('url');
			
			if (typeof url === typeof undefined || url === false) {
				url = $(this).val();
			}
			
			$(this).val(url);
		});
		
		if (!found) {
			$(container).find('.avselection').each(function() {
				url = $(this).attr('url');
				
				if (typeof url === typeof undefined || url === false) {
					url = $(this).val();
				}
				
				$(this).val(url);
			});
		}

		return url;
	};


})(jQuery);