/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
! function($) {
	$(function() {
		$(document).on('initCollapsibleMenu', function() {
			if ($('.vpf-collapsible-menu').length) {
				var $CollapsibleMenuParentLi, $CollapsibleSubMenu;

				$('.vpf-collapsible-menu .opener').on('click tap', function() {
					$CollapsibleMenuParentLi = $(this).parent().parent('li.deeper');
					$CollapsibleSubMenu = $CollapsibleMenuParentLi.children('ul');
					$CollapsibleSubMenu.slideToggle(300);
					$CollapsibleMenuParentLi.toggleClass('open');
					$CollapsibleMenuParentLi.find('a, span').blur();
					$(document).trigger('initCollapsibleMenuState');
					setTimeout(function() {
						if ($.fn.nanoScroller) $('.vpf-offcanvas').nanoScroller();
					}, 350);
					return false;
				});

				$(document).on('initCollapsibleMenuState', function() {
					$('.vpf-collapsible-menu li').each(function() {
						if ($(this).find('li.active').length) {
							if ($(this).hasClass('open')) {
								$(this).removeClass('active');
							} else {
								$(this).addClass('active');
							}
						}
					})
				});

				$(document).trigger('initCollapsibleMenuState');
			}
		});

		$(document).trigger('initCollapsibleMenu');
	})
}(jQuery);