<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Load mandatory VP Framwork libraries which includes Bootstrap and other utilities like icons.css, animate.css etc
$template->loadFramework($responsive);

if ($this->params->get('responsive', 1))
{
	$doc->setMetaData('X-UA-Compatible', 'IE=edge', true);
	$doc->setMetaData('HandheldFriendly', 'true', false);
	$doc->setMetaData('apple-touch-fullscreen', 'yes', false);
	$doc->setMetaData('viewport', 'width=device-width, initial-scale=1.0', false);
}

if (version_compare(JVERSION, '4.0.0', 'ge'))
{
	// Load template CSS
	$doc->addStyleSheet($template->uri . '/css/colors_standard.fee.j4.min.css');
	$doc->addStyleSheet($template->uri . '/css/template.fee.j4.css');
	$doc->addStyleSheet($template->uri . '/css/choices.fee.j4.min.css');
	
	// Load template JavaScripts
	$doc->addScript($template->uri . '/js/template.fee.j4.js');
}
else
{
	// Load template CSS
	$doc->addStyleSheet($template->uri . '/css/template.fee.css');

	if ($print)
	{
		$doc->addStyleSheet($template->uri . '/css/print.css', 'text/css', 'print');
	}

	// Load template JavaScripts
	$doc->addScript($template->uri . '/js/template.fee.js');
}

// Do we need to load Google Fonts
if ($params->get('useGoogleFont', 0))
{
	$fontFamilies = array();
	$fontCSS = array();
	
	if ($params->get('googleFontName', ''))
	{
		$fontName       = $this->params->get('googleFontName', '');
		$fontVariant    = $this->params->get('googleFontVariant', '');
		$fontSubsets    = $this->params->get('googleFontSubsets', array());
		$fontFamily     = $template->getGoogleFontFamily($fontName, $fontVariant, $fontSubsets);
		$fontCSS[]      = $template->getGoogleFontCSS('body', $fontName, $fontVariant, 'Verdana');
		$fontFamilies[] = "'" . $fontFamily . "'";
	}
	
	if ($params->get('header_googleFontName', ''))
	{
		$fontName       = $this->params->get('header_googleFontName', '');
		$fontVariant    = $this->params->get('header_googleFontVariant', '');
		$fontSubsets    = $this->params->get('header_googleFontSubsets', array());
		$fontFamily     = $template->getGoogleFontFamily($fontName, $fontVariant, $fontSubsets);
		$fontCSS[]      = $template->getGoogleFontCSS('header', $fontName, $fontVariant, 'Verdana');
		
		if (!in_array($fontFamily, $fontFamilies))
		{
			$fontFamilies[] = "'" . $fontFamily . "'";
		}
	}
	
	if (!empty($fontFamilies) && !empty($fontCSS))
	{
		$fontFamilies = implode(',', $fontFamilies);
		$fontJS = $template->getGoogleFontJS($fontFamilies);
		$fontCSS = implode($lineEnd, $fontCSS) . $lineEnd;
		$doc->addStyleDeclaration($fontCSS);
		$doc->addScriptDeclaration($fontJS);
	}
}

// Include IE warning script
if ($params->get('show_ie8_alert', 1))
{
	$ie8Warning = '
  <!--[if lt IE 9]>
    <script src="' . $template->media_uri . '/js/ie8-responsive-file-warning.js"></script>
  <![endif]-->';
  $doc->addCustomTag($ie8Warning);
}

// Include IE Emulation Modes Warning script
if ($params->get('show_ie_emulation_alert', 1))
{
	$ieEmulationWarning = '
  <!--[if IE]>
    <script src="' . $template->media_uri . '/js/ie-emulation-modes-warning.js"></script>
  <![endif]-->';
  $doc->addCustomTag($ieEmulationWarning);
}

// For old IE browsers to support HTML5
$forOldIE = '
  <!--[if lt IE 9]>
    <script src="' . JUri::root(true) . '/media/jui/js/html5.js"></script>
  <![endif]-->';
$doc->addCustomTag($forOldIE);
?>
<head>
<jdoc:include type="head" />
</head>
