<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$leftGridSize = (int) $params->get('left_grid', 3);
$rightGridSize = (int) $params->get('right_grid', 3);
$mainGridSize = (int) $params->get('main_grid', 6);

// Adjusting content width
if($isFullWidth)
{
	$mainWidth = 'col-xs-12 col-sm-12 col-md-12';
	$leftWidth = '';
	$rightWidth = '';
}
elseif ($this->countModules('left') && $this->countModules('right'))
{
	$validLeftSize = $template->getValidGridSize($leftGridSize, 'md');
	$validRightSize = $template->getValidGridSize($rightGridSize, 'md');
	$validMainSize = $template->getValidGridSize($mainGridSize, 'md');
	
	$mainWidth = 'col-xs-12 col-sm-12 ' . $validMainSize;
	$leftWidth = 'col-xs-12 col-sm-12 ' . $validLeftSize;
	$rightWidth = 'col-xs-12 col-sm-12 ' . $validRightSize;

	if(($params->get('left_module_position', 'below') == 'below') && $validLeftSize != 'hidden-md' && $validMainSize != 'hidden-md')
	{
		$mainWidth .= ' col-md-push-' . $leftGridSize;
		$leftWidth .= ' col-md-pull-' . $mainGridSize;
	}
}
elseif ($this->countModules('left') && !$this->countModules('right'))
{
	$validLeftSize = $template->getValidGridSize($leftGridSize, 'md');
	$validMainSize = $template->getValidGridSize(($mainGridSize + $rightGridSize), 'md');
		
	$mainWidth = 'col-xs-12 col-sm-12 ' . $validMainSize;
	$leftWidth = 'col-xs-12 col-sm-12 ' . $validLeftSize;
	$rightWidth = '';
	
	if(($params->get('left_module_position', 'below') == 'below') && $validLeftSize != 'hidden-md' && $validMainSize != 'hidden-md')
	{
		$mainWidth .= ' col-md-push-' . $leftGridSize;
		$leftWidth .= ' col-md-pull-' . ($mainGridSize + $rightGridSize);
	}
}
elseif (!$this->countModules('left') && $this->countModules('right'))
{
	$validRightSize = $template->getValidGridSize($rightGridSize, 'md');
	$validMainSize = $template->getValidGridSize(($mainGridSize + $leftGridSize), 'md');
		
	$mainWidth = 'col-xs-12 col-sm-12 ' . $validMainSize;
	$leftWidth = '';
	$rightWidth = 'col-xs-12 col-sm-12 ' . $validRightSize;
}
else
{
	$mainWidth = 'col-xs-12 col-sm-12 col-md-12';
	$leftWidth = '';
	$rightWidth = '';
}

$posClassLeft = '';

$hasUtlity = $this->countModules('utility-wide') || $this->countModules('utility-vertical') || $this->countModules('utility-horizontal');
$mainbodyClass = $hasUtlity ? ' class="no-padding"' : '';
?>
<div id="mainbody"<?php echo $mainbodyClass; ?>>
	<div class="container">
		<div class="inner-container">
			<?php if ($this->countModules('main-top-vertical')) : ?>
				<section class="main-top-vertical">
					<div class="row">
						<jdoc:include type="modules" name="main-top-vertical" style="row" />
					</div>
				</section>
			<?php endif; ?>
			<?php if ($this->countModules('main-top-horizontal')) : ?>
				<section class="main-top-horizontal">
					<div class="row">
						<jdoc:include type="modules" name="main-top-horizontal" style="autowidth" />
					</div>
				</section>
			<?php endif; ?>
			<div class="row">
				<?php if ($this->countModules('left') && !$isFullWidth && ($params->get('left_module_position', 'below') == 'above')) : ?>
					<aside id="left-aside" class="<?php echo $leftWidth ?>">
						<?php if($params->get('vm_collapse_left_postion', 1) && $option == 'com_virtuemart' && $view == 'category') : ?>
							<?php $posClassLeft = ' modpos-collapse'; ?>
						<?php endif; ?>
						<div class="aside-inner<?php echo $posClassLeft ?>">
							<jdoc:include type="modules" name="left" style="block" />
						</div>
					</aside>
				<?php endif; ?>
				<div id="content" class="<?php echo $mainWidth; ?>">
					<?php if ($this->countModules('content-top-vertical')) : ?>
						<section class="content-top-vertical">
							<div class="row">
								<jdoc:include type="modules" name="content-top-vertical" style="row" />
							</div>
						</section>
					<?php endif; ?>
					<?php if ($this->countModules('content-top-horizontal')) : ?>
						<section class="content-top-horizontal">
							<div class="row">
								<jdoc:include type="modules" name="content-top-horizontal" style="autowidth" />
							</div>
						</section>
					<?php endif; ?>
					<main id="main" role="main">
						<jdoc:include type="message" />
						<jdoc:include type="component" />
					</main>
					<?php if ($this->countModules('content-bottom-vertical')) : ?>
						<section class="content-bottom-vertical">
							<div class="row">
								<jdoc:include type="modules" name="content-bottom-vertical" style="row" />
							</div>
						</section>
					<?php endif; ?>
					<?php if ($this->countModules('content-bottom-horizontal')) : ?>
						<section class="content-bottom-horizontal">
							<div class="row">
								<jdoc:include type="modules" name="content-bottom-horizontal" style="autowidth" />
							</div>
						</section>
					<?php endif; ?>
				</div>
				<?php if ($this->countModules('left') && !$isFullWidth && ($params->get('left_module_position', 'below') == 'below')) : ?>
					<aside id="left-aside" class="<?php echo $leftWidth ?>">
						<?php if($params->get('vm_collapse_left_postion', 1) && $option == 'com_virtuemart' && $view == 'category') : ?>
							<?php $posClassLeft = ' modpos-collapse'; ?>
						<?php endif; ?>
						<div class="aside-inner<?php echo $posClassLeft ?>">
							<jdoc:include type="modules" name="left" style="block" />
						</div>
					</aside>
				<?php endif; ?>
				<?php if ($this->countModules('right')  && !$isFullWidth) : ?>
					<aside id="right-aside" class="<?php echo $rightWidth ?>">
						<div class="aside-inner">
							<jdoc:include type="modules" name="right" style="block" />
						</div>
					</aside>
				<?php endif; ?>
			</div>
			<?php if ($this->countModules('main-bottom-vertical')) : ?>
				<section class="main-bottom-vertical">
					<div class="row">
						<jdoc:include type="modules" name="main-bottom-vertical" style="row" />
					</div>
				</section>
			<?php endif; ?>
			<?php if ($this->countModules('main-bottom-horizontal')) : ?>
				<section class="main-bottom-horizontal">
					<div class="row">
						<jdoc:include type="modules" name="main-bottom-horizontal" style="autowidth" />
					</div>
				</section>
			<?php endif; ?>
		</div>
	</div>
</div>