<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$debug = JFactory::getConfig()->get('debug_lang');
$backToHome = JText::_('JERROR_LAYOUT_GO_TO_THE_HOME_PAGE');
$homePage = '<a href="' . $this->baseurl . '/index.php">' . JText::_('JERROR_LAYOUT_HOME_PAGE') . '</a>';
$backToHome = str_replace(JText::_('JERROR_LAYOUT_HOME_PAGE'), $homePage, $backToHome);

if (!isset($this->error))
{
	$this->error = JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	$this->debug = false;
}
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" class="<?php echo $htmlClass ?>">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="x-ua-compatible" content="IE=edge" />
    <meta name="handheldfriendly" content="true" />
    <meta name="apple-touch-fullscreen" content="yes" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <title><?php echo $this->title; ?> <?php echo htmlspecialchars($this->error->getMessage()); ?></title>
    <link href="<?php echo $template->uri ?>/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />
    <link rel="stylesheet" href="<?php echo $template->media_uri ?>/css/animate.css" type="text/css" />
    <link rel="stylesheet" href="<?php echo $template->media_uri ?>/css/bootstrap.min.css" type="text/css" />
    <link rel="stylesheet" href="<?php echo $template->uri ?>/css/error.css" type="text/css" />
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Roboto" type="text/css" />
<?php if ((defined('JDEBUG') && JDEBUG) || $debug) : ?>
    <link rel="stylesheet" href="<?php echo $this->baseurl ?>/media/cms/css/debug.css" type="text/css" />
<?php endif; ?>
  </head>
  <body class="error-page<?php echo $this->debug ? ' debug-enabled' : ''; ?>">
    <div class="jumbotron">
      <div class="container">
        <div class="error-box">
          <h1><?php echo $this->error->getCode(); ?></h1>
          <h2><?php echo JText::_('JERROR_LAYOUT_ERROR_HAS_OCCURRED_WHILE_PROCESSING_YOUR_REQUEST'); ?></h2>
          <p><?php echo JText::_('JERROR_LAYOUT_PLEASE_CONTACT_THE_SYSTEM_ADMINISTRATOR'); ?></p>
          <blockquote>
            <kbd><?php echo $this->error->getCode(); ?></kbd><span>&nbsp;&nbsp;<?php echo $this->error->getMessage();?></span>
            <?php if ($this->debug) : ?>
              <br/><?php echo htmlspecialchars($this->error->getFile(), ENT_QUOTES, 'UTF-8');?>:<?php echo $this->error->getLine(); ?>
            <?php endif; ?>
          </blockquote>
        </div>
        <div class="footer">
          <p><?php echo $backToHome ?></p>
        </div>
        
        <?php if ($this->debug) : ?>
          <div class="debug-info">
            <?php echo $this->renderBacktrace(); ?>
            <?php // Check if there are more Exceptions and render their data as well ?>
            <?php if ($this->error->getPrevious()) : ?>
              <?php $loop = true; ?>
              <?php // Reference $this->_error here and in the loop as setError() assigns errors to this property and we need this for the backtrace to work correctly ?>
              <?php // Make the first assignment to setError() outside the loop so the loop does not skip Exceptions ?>
              <?php $this->setError($this->_error->getPrevious()); ?>
              <?php while ($loop === true) : ?>
                <p><strong><?php echo JText::_('JERROR_LAYOUT_PREVIOUS_ERROR'); ?></strong></p>
                <p>
                  <?php echo htmlspecialchars($this->_error->getMessage(), ENT_QUOTES, 'UTF-8'); ?>
                  <br/><?php echo htmlspecialchars($this->_error->getFile(), ENT_QUOTES, 'UTF-8');?>:<?php echo $this->_error->getLine(); ?>
                </p>
              <?php echo $this->renderBacktrace(); ?>
                <?php $loop = $this->setError($this->_error->getPrevious()); ?>
              <?php endwhile; ?>
              <?php // Reset the main error object to the base error ?>
              <?php $this->setError($this->error); ?>
            <?php endif; ?>
          </div>
        <?php endif; ?>
        
      </div>
    </div>

  </body>
</html>