<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

if (!version_compare(JVERSION, '4.0.0', 'ge'))
{
	require_once JPATH_SITE . '/components/com_content/helpers/route.php';
}
?>
<?php if ($this->params->get('show_articles')) : ?>
<div class="contact-articles">
	<ul class="nav nav-tabs nav-stacked">
		<?php foreach ($this->item->articles as $article) :	?>
			<li>
				<?php if (!version_compare(JVERSION, '4.0.0', 'ge')) : ?>
					<?php echo JHtml::_('link', JRoute::_(ContentHelperRoute::getArticleRoute($article->slug, $article->catslug, $article->language)), htmlspecialchars($article->title, ENT_COMPAT, 'UTF-8')); ?>
				<?php else : ?>
					<?php echo JHtml::_('link', JRoute::_(Joomla\Component\Content\Site\Helper\RouteHelper::getArticleRoute($article->slug, $article->catid, $article->language)), htmlspecialchars($article->title, ENT_COMPAT, 'UTF-8')); ?>
				<?php endif; ?>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php endif; ?>
