<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;
?>
<?php // Display the suggested search if it is different from the current search. ?>
<?php if (($this->suggested && $this->params->get('show_suggested_query', 1)) || ($this->explained && $this->params->get('show_explained_query', 1))) : ?>
	<div id="search-query-explained">
		<?php // Display the suggested search query. ?>
		<?php if (version_compare(JVERSION, '4.0.0', 'ge') && $this->suggested && $this->params->get('show_suggested_query', 1)) : ?>
			<?php // Replace the base query string with the suggested query string. ?>
			<?php $uri = JUri::getInstance($this->query->toUri()); ?>
			<?php $uri->setVar('q', $this->suggested); ?>
			<?php // Compile the suggested query link. ?>
			<?php $linkUrl = JRoute::_($uri->toString(array('path', 'query'))); ?>
			<?php $link = '<a href="' . $linkUrl . '">' . $this->escape($this->suggested) . '</a>'; ?>
			<?php echo JText::sprintf('COM_FINDER_SEARCH_SIMILAR', $link); ?>
		<?php elseif ($this->explained && $this->params->get('show_explained_query', 1)) : ?>
			<?php // Display the explained search query. ?>
			<p role="alert">
				<?php echo version_compare(JVERSION, '4.0.0', 'ge') ? JText::plural('COM_FINDER_QUERY_RESULTS', $this->total, $this->explained) : $this->explained; ?>
			</p>
		<?php endif; ?>
	</div>
<?php endif; ?>

<?php // Display the 'no results' message and exit the template. ?>
<?php if ($this->total == 0) : ?>
	<div id="search-result-empty">
		<h2 class="no-result-heading"><?php echo JText::_('COM_FINDER_SEARCH_NO_RESULTS_HEADING'); ?></h2>
		<?php $multilang = JFactory::getApplication()->getLanguageFilter() ? '_MULTILANG' : ''; ?>
		<p class="bg-box bg-warning"><?php echo JText::sprintf('COM_FINDER_SEARCH_NO_RESULTS_BODY' . $multilang, $this->escape($this->query->input)); ?></p>
	</div>

	<?php // Exit this template. ?>
	<?php return; ?>
<?php endif; ?>

<?php // Activate the highlighter if enabled. ?>
<?php if (!empty($this->query->highlight) && $this->params->get('highlight_terms', 1)) : ?>
	<?php JHtml::_('behavior.highlighter', $this->query->highlight); ?>
<?php endif; ?>

<?php // Display a list of results ?>
<br id="highlighter-start" />
<ul class="search-results<?php echo $this->pageclass_sfx; ?> list-striped">
	<?php $this->baseUrl = JUri::getInstance()->toString(array('scheme', 'host', 'port')); ?>

	<?php foreach ($this->results as $result) : ?>
		<?php $this->result = &$result; ?>
		<?php $layout = $this->getLayoutFile($this->result->layout); ?>
		<?php echo $this->loadTemplate($layout); ?>
	<?php endforeach; ?>
</ul>
<br id="highlighter-end" />

<?php // Display the pagination ?>
<div class="search-pagination">
	<div class="pagination">
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<div class="search-pages-counter">
		<?php
			// Prepare the pagination string.  Results X - Y of Z
			if (version_compare(JVERSION, '4.0.0', 'ge'))
			{
				$start = (int) $this->pagination->limitstart + 1; 
				$total = (int) $this->pagination->total; 
				$limit = (int) $this->pagination->limit * $this->pagination->pagesCurrent;
				$limit = (int) ($limit > $total ? $total : $limit); 
			}
			else
			{
				$start = (int) $this->pagination->get('limitstart') + 1;
				$total = (int) $this->pagination->get('total');
				$limit = (int) $this->pagination->get('limit') * $this->pagination->pagesTotal;
				$limit = (int) ($limit > $total ? $total : $limit);
			}

			echo JText::sprintf('COM_FINDER_SEARCH_RESULTS_OF', $start, $limit, $total);
		?>
	</div>
</div>
