<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;
?>
<ol class="search-results<?php echo $this->pageclass_sfx; ?> list-striped">
<?php foreach ($this->results as $result) : ?>
	<li>
		<h4 class="result-title">
			<?php echo $this->pagination->limitstart + $result->count . '. ';?>
			<?php if ($result->href) :?>
				<a href="<?php echo JRoute::_($result->href); ?>"<?php if ($result->browsernav == 1) :?> target="_blank"<?php endif;?>>
					<?php echo $result->title; ?>
				</a>
			<?php else:?>
				<?php echo $result->title; ?>
			<?php endif; ?>
		</h4>
		<p class="result-text">
			<?php echo $result->text; ?>
		</p>
		<ul class="list-inline">
			<?php if($result->section) : ?>
				<li class="result-category">
					<span class="text-muted<?php echo $this->pageclass_sfx; ?>"><?php echo $this->escape($result->section); ?></span>
				</li>
			<?php endif; ?>
			<?php if($this->params->get('show_date') && $result->created) : ?>
				<li class="result-created<?php echo $this->pageclass_sfx; ?>">
					<span class="text-muted<?php echo $this->pageclass_sfx; ?>"><?php echo JText::sprintf('JGLOBAL_CREATED_DATE_ON', $result->created); ?></span>
				</li>
			<?php endif; ?>
		</ul>
	</li>
<?php endforeach; ?>
</ol>

<div class="pagination-container">
	<?php echo $this->pagination->getPagesLinks(); ?>
</div>
