<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
?>
<div class="narrow-container logout<?php echo $this->pageclass_sfx?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
	<div class="page-header">
		<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
	</div>
	<?php endif; ?>

	<?php if (($this->params->get('logoutdescription_show') == 1 && str_replace(' ', '', $this->params->get('logout_description', '')) != '')|| $this->params->get('logout_image', '') != '') : ?>
		<div class="logout-description">
			<?php if ($this->params->get('logoutdescription_show') == 1) : ?>
				<?php echo $this->params->get('logout_description'); ?>
			<?php endif; ?>
			<?php if (($this->params->get('logout_image') != '')) :?>
				<img src="<?php echo $this->escape($this->params->get('logout_image')); ?>" class="img-thumbnail pull-right logout-image" alt="<?php echo JTEXT::_('COM_USER_LOGOUT_IMAGE_ALT')?>"/>
			<?php endif; ?>
		</div>
	<?php endif; ?>

	<form action="<?php echo JRoute::_('index.php?option=com_users&task=user.logout'); ?>" method="post" class="form-horizontal">
		<?php 
		$name = !empty($this->user->name) ? $this->user->name : $this->user->username;
		echo JText::sprintf('COM_USERS_PROFILE_WELCOME', '<strong>' . $name . '</strong>');
		?>
		<div class="form-buttons-cont">
			<button type="submit" class="btn btn-base btn-lg"><i class="icon-arrow-left3"></i> <?php echo JText::_('JLOGOUT'); ?></button>
		</div>		
		<input type="hidden" name="return" value="<?php echo base64_encode($this->params->get('logout_redirect_url', $this->form->getValue('return'))); ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
