<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

JHtml::_('jquery.framework');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
?>
<div class="narrow-container registration<?php echo $this->pageclass_sfx?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>
	<div class="narrow-inner">
		<form id="member-registration" action="<?php echo JRoute::_('index.php?option=com_users&task=registration.register'); ?>" method="post" class="form-validate old-form" enctype="multipart/form-data">
			<?php foreach ($this->form->getFieldsets() as $fieldset) : // Iterate through the form fieldsets and display each one.?>
				<?php $fields = $this->form->getFieldset($fieldset->name);?>
				<?php if (count($fields)):?>
					<fieldset>
						<?php if (isset($fieldset->label)) :// If the fieldset has a label set, display it as the legend.?>
							<legend><?php echo JText::_($fieldset->label);?></legend>
						<?php endif;?>
						<?php foreach ($fields as $field) :// Iterate through the fields in the set and display them.?>
							<?php if ($field->hidden):// If the field is hidden, just display the input.?>
								<?php echo $field->input; ?>
							<?php else:?>
								<div class="form-group">
									<?php if ($field->getAttribute('hiddenLabel') !== 'true') : ?>
										<?php echo $field->label; ?>
									<?php endif; ?>
									<?php echo $field->input; ?>
								</div>
							<?php endif;?>
						<?php endforeach; ?>
					</fieldset>
				<?php endif;?>
			<?php endforeach;?>
			<div class="form-group">
				<button type="submit" class="btn btn-base btn-lg validate"><?php echo JText::_('JREGISTER');?></button>
				&nbsp;<a class="btn btn-default btn-lg" href="<?php echo JRoute::_('index.php?option=com_users&view=login');?>" title="<?php echo JText::_('JCANCEL');?>"><?php echo JText::_('JCANCEL');?></a>
			</div>
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="task" value="registration.register" />
			<?php echo JHtml::_('form.token');?>
		</form>
	</div>
</div>
