<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<?php if($this->format != 'pdf') : ?>
	<div class="table-responsive">
<?php endif; ?>

<table class="table table-striped table-condensed" width="100%" cellspacing="0" cellpadding="0" border="0">
	<thead>
		<tr valign="top">
			<th align="left" width="5%" class="align-left">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SKU') ?>
			</th>
			<th align="left" colspan="2" width="25%" class="align-left">
				<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NAME_TITLE') ?>
			</th>
			<th align="center" width="15%" class="align-center">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_STATUS') ?>
			</th>
			<th align="right" width="10%" class="align-right">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRICE') ?>
			</th>
			<th align="left" width="5%" class="align-center">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_QTY') ?>
			</th>
			<?php if(VmConfig::get('show_tax')) : ?>
				<th align="right" width="10%" class="align-right">
					<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_TAX') ?>
				</th>
			<?php endif; ?>
			<th align="right" width="11%" class="align-right">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SUBTOTAL_DISCOUNT_AMOUNT') ?>
			</th>
			<th align="right" width="10%" class="align-right">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php foreach($this->orderdetails['items'] as $item) : ?>
			<?php
			$qtt = $item->product_quantity ;
			$_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_category_id=' . $item->virtuemart_category_id . '&virtuemart_product_id=' . $item->virtuemart_product_id, FALSE);
			?>
			<tr valign="top">
				<td align="left">
					<?php echo $item->order_item_sku; ?>
				</td>
				<td align="left" colspan="2">
					<div class="ordered-product-name">
						<a href="<?php echo $_link; ?>" class="hover-invert" title="<?php echo $item->order_item_name; ?>"><?php echo $item->order_item_name; ?></a>
					</div>
					<?php
					if(!class_exists('VirtueMartModelCustomfields'))require(VMPATH_ADMIN . '/models/customfields.php');
					$product_attribute = VirtueMartModelCustomfields::CustomsFieldOrderDisplay($item, 'FE');
					echo $product_attribute;
					?>
				</td>
				<td align="center" class="align-center">
					<?php echo $this->orderstatuses[$item->order_status]; ?>
				</td>
				<td align="right" class="priceCol align-right nowrap">
					<?php
					$item->product_discountedPriceWithoutTax = (float) $item->product_discountedPriceWithoutTax;
					if (!empty($item->product_priceWithoutTax) && $item->product_discountedPriceWithoutTax != $item->product_priceWithoutTax) 
					{
						echo '<s>' . $this->currency->priceDisplay($item->product_item_price, $this->currency) . '</s><br />';
						echo $this->currency->priceDisplay($item->product_discountedPriceWithoutTax, $this->currency);
					} 
					else 
					{
						echo $this->currency->priceDisplay($item->product_item_price, $this->currency); 
					} ?>
				</td>
				<td align="center" class="align-center">
					<?php echo $qtt; ?>
				</td>
				<?php if(VmConfig::get('show_tax')) : ?>
					<td align="right" class="priceCol align-right nowrap">
						<?php echo $this->currency->priceDisplay($item->product_tax ,$this->currency, $qtt) ?></td>
				<?php endif; ?>
				<td align="right" class="priceCol align-right nowrap">
					<?php echo $this->currency->priceDisplay($item->product_subtotal_discount, $this->currency);  ?>
				</td>
				<td align="right" class="priceCol align-right nowrap">
					<?php
					$item->product_basePriceWithTax = (float) $item->product_basePriceWithTax;
					if(!empty($item->product_basePriceWithTax) && $item->product_basePriceWithTax != $item->product_final_price ) 
					{
						echo '<s>'.$this->currency->priceDisplay($item->product_basePriceWithTax,$this->currency,$qtt) .'</s><br/>' ;
					}
					elseif (empty($item->product_basePriceWithTax) && $item->product_item_price != $item->product_final_price) 
					{
						echo '<s>' . $this->currency->priceDisplay($item->product_item_price,$this->currency,$qtt) . '</s><br/>';
					}
					echo $this->currency->priceDisplay(  $item->product_subtotal_with_tax ,$this->currency); ?>
				</td>
			</tr>
		<?php endforeach; ?>
		
		<tr>
			<td colspan="6" align="right" class="align-right">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_PRICES_TOTAL'); ?>
			</td>
			<?php if(VmConfig::get('show_tax')) : ?>
				<td align="right" class="align-right nowrap">
					<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_tax,$this->currency) ?>
				</td>
			<?php endif; ?>
			<td align="right" class="align-right nowrap">
				<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_discountAmount,$this->currency) ?>
			</td>
			<td align="right" class="align-right nowrap">
				<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_salesPrice,$this->currency) ?>
			</td>
		</tr>
		
		<?php if($this->orderdetails['details']['BT']->coupon_discount <> 0.00) : ?>
    	<?php $coupon_code=$this->orderdetails['details']['BT']->coupon_code ? ' ('.$this->orderdetails['details']['BT']->coupon_code.')' : ''; ?>
			<tr>
				<td align="right" class="pricePad align-right" colspan="6">
					<?php echo vmText::_('COM_VIRTUEMART_COUPON_DISCOUNT') . $coupon_code ?>
				</td>
				<?php if(VmConfig::get('show_tax')) : ?>
					<td>&nbsp;</td>
				<?php endif; ?>
				<td>&nbsp;</td>
				<td align="right" class="align-right nowrap">
					<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->coupon_discount, $this->currency); ?>
				</td>
			</tr>
		<?php endif; ?>

		<?php foreach($this->orderdetails['calc_rules'] as $rule) : ?>
			<?php if($rule->calc_kind == 'DBTaxRulesBill') : ?>
				<tr>
					<td colspan="6" align="right" class="pricePad align-right">
						<?php echo $rule->calc_rule_name ?>
					</td>
					<?php if(VmConfig::get('show_tax')) : ?>
						<td>&nbsp;</td>
					<?php endif; ?>
					<td align="right" class="align-right nowrap">
						<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
					</td>
					<td align="right" class="align-right nowrap">
						<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
					</td>
				</tr>
			<?php elseif($rule->calc_kind == 'taxRulesBill') : ?>
				<tr>
					<td colspan="6" align="right" class="pricePad align-right">
						<?php echo $rule->calc_rule_name ?>
					</td>
					<?php if(VmConfig::get('show_tax')) : ?>
						<td align="right" class="align-right nowrap">
							<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
						</td>
					<?php endif; ?>
					<td>&nbsp;</td>
					<td align="right" class="align-right nowrap">
						<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
					</td>
				</tr>
			<?php elseif($rule->calc_kind == 'DATaxRulesBill') : ?>
				<tr>
					<td colspan="6" align="right" class="pricePad align-right">
						<?php echo $rule->calc_rule_name ?>
					</td>
					<?php if(VmConfig::get('show_tax')) : ?>
						<td>&nbsp;</td>
					<?php endif; ?>
					<td align="right" class="align-right nowrap">
						<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
					</td>
					<td align="right" class="align-right nowrap">
						<?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?>
					</td>
				</tr>
			<?php endif; ?>
		<?php endforeach; ?>

		<tr>
			<td align="right" class="pricePad align-right" colspan="6">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SHIPPING') ?>
			</td>
			<?php if(VmConfig::get('show_tax')) : ?>
				<td align="right" class="align-right nowrap">
					<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_shipment_tax, $this->currency) ?>
				</td>
			<?php endif; ?>
			<td>&nbsp;</td>
			<td align="right" class="align-right nowrap">
				<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_shipment + $this->orderdetails['details']['BT']->order_shipment_tax, $this->currency); ?>
			</td>
		</tr>

		<tr>
			<td align="right" class="pricePad align-right" colspan="6">
				<?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PAYMENT'); ?>
			</td>
			<?php if(VmConfig::get('show_tax')) : ?>
				<td align="right" class="align-right nowrap">
					<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_payment_tax, $this->currency) ?>
				</td>
			<?php endif; ?>
			<td>&nbsp;</td>
			<td align="right" class="align-right nowrap">
				<?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_payment+ $this->orderdetails['details']['BT']->order_payment_tax, $this->currency); ?>
			</td>
		</tr>

		<tr class="warning">
			<td align="right" class="pricePad align-right" colspan="6">
				<strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></strong>
			</td>
			<?php if ( VmConfig::get('show_tax')) :  ?>
				<td align="right" class="align-right nowrap">
					<strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_billTaxAmount, $this->currency); ?></strong>
				</td>
			<?php endif; ?>
			<td align="right" class="align-right nowrap">
				<strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_billDiscountAmount, $this->currency); ?></strong
			</td>
			<td align="right" class="align-right nowrap">
				<strong><?php echo $this->currency->priceDisplay($this->orderdetails['details']['BT']->order_total, $this->currency); ?></strong>
			</td>
		</tr>
		
	</tbody>
</table>
	
<?php if($this->format != 'pdf') : ?>
	</div>
<?php endif; ?>