<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<div class="vm-order-list-page">
	<div class="page-header">
		<h1><?php echo vmText::_('COM_VIRTUEMART_ORDERS_VIEW_DEFAULT_TITLE'); ?></h1>
	</div>
	<?php if(empty($this->orderlist)) : ?>
		<div class="order-list-login-form">
			<?php echo shopFunctionsF::getLoginForm(false, true); ?>
		</div>
	<?php else : ?>
		<table class="table table-striped table-hover">
			<thead>
				<tr>
					<th class="align-left"><?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_ORDER_NUMBER'); ?></th>
					<th class="align-center"><?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_CDATE'); ?></th>
					<th class="align-center hidden-xs"><?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_MDATE'); ?></th>
					<th class="align-center"><?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_STATUS'); ?></th>
					<th class="align-right"><?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_TOTAL'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($this->orderlist as $row) : ?>
					<tr>
						<td class="align-left">
							<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $row->order_number, false); ?>" rel="nofollow"><?php echo $row->order_number; ?></a>
						</td>
						<td class="align-center">
							<?php echo JHtml::_('date', $row->created_on); ?>
						</td>
						<td class="align-center hidden-xs">
							<?php echo JHtml::_('date', $row->modified_on); ?>
						</td>						
						<td class="align-center">
							<?php echo shopFunctionsF::getOrderStatusName($row->order_status); ?>
						</td>
						<td class="align-right nowrap">
							<?php echo $this->currency->priceDisplay($row->order_total, $row->currency); ?>
						</td>
					</tr>			
				<?php endforeach; ?>
			</tbody>
		</table>
	<?php endif; ?>
</div>