<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$app      = JFactory::getApplication();
$template = plgSystemVPFrameworkHelper::getTemplate();

if (empty($this->product)) 
{
	// If product not found
	echo '<p class="bg-box bg-danger">';
	echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND');
	echo $this->continue_link_html;
	echo '</p>';
	return;
}
elseif ($app->input->getInt('quickview', 0))
{
	// If quick view
	$this->setLayout('quickview');
	return $template->loadView($this);
}

/* Start Normal product page layout */
// Set required variables
$doc                           = JFactory::getDocument();
$print                         = $app->input->getInt('print', 0);
$params                        = $template->params;
$tabs                          = VPFrameworkVM::getTabsData($this->product);
$tabTitles                     = $tabs['titles'];
$tabDisplays                   = $tabs['displays'];
$related                       = VPFrameworkVM::getRelatedFields($this->product);
$this->productDisplayShipments = is_array($this->productDisplayShipments) ?
                                 array_filter($this->productDisplayShipments) :
                                 array_filter(array($this->productDisplayShipments));
$this->productDisplayPayments  = is_array($this->productDisplayPayments) ?
                                 array_filter($this->productDisplayPayments) :
                                 array_filter(array($this->productDisplayPayments));
$showNavigation                = (VmConfig::get('product_navigation', 1) && !$print) &&
                                 (!empty($this->product->neighbours['previous'][0]) || !empty($this->product->neighbours['next'][0]));
$showTopRight                  = (VmConfig::get('show_manufacturers', 1) && !empty($this->product->virtuemart_manufacturer_id)) ||
                                 (isset($this->product->customfieldsSorted['top-right']) && !empty($this->product->customfieldsSorted['top-right'])) ||
                                 (is_array($this->productDisplayShipments) && !empty($this->productDisplayShipments)) ||
                                 (is_array($this->productDisplayPayments) && !empty($this->productDisplayPayments));
$imageClass                    = $showTopRight ? 'col-md-4 col-sm-5' : 'col-md-5 col-sm-5';
$mainClass                     = $showTopRight ? 'col-md-5 col-sm-7' : 'col-md-7 col-sm-7';
$askquestion_url               = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $this->product->virtuemart_product_id .
                                           '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component', false);
$vmeParams                     = defined ('VMESSENTIALS_ADMINISTRATOR') ? JComponentHelper::getParams('com_vmessentials') : null;
$metaDescription               = $doc->getMetaData('description');
$stockhandle                   = VmConfig::get('stockhandle_products', false) && $this->product->product_stockhandle ? $this->product->product_stockhandle : VmConfig::get('stockhandle', 'none');

if ($showNavigation)
{
	$globalHelper = VPFrameworkGlobal::getInstance();
	
	if (!empty($this->product->neighbours['previous'][0]))
	{
		$prev_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' .
		                       $this->product->neighbours['previous'][0]['virtuemart_product_id'] .
		                       '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false);
		$prev_product_name = $this->product->neighbours ['previous'][0]['product_name'];
		
		$globalHelper->setState('previous_item', array('url' => $prev_link, 'text' => $prev_product_name));
	}
	
	if (!empty($this->product->neighbours['next'][0]))
	{
		$next_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' .
		                       $this->product->neighbours['next'][0]['virtuemart_product_id'] .
		                       '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false);
		$next_product_name = $this->product->neighbours ['next'][0]['product_name'];
		
		$globalHelper->setState('next_item', array('url' => $next_link, 'text' => $next_product_name));
	}
}

$js = "
jQuery(document).ready(function($) { 
  if (Virtuemart.container) {
    Virtuemart.updateDynamicUpdateListeners();
  }
});
";
vmJsApi::jDynUpdate();
vmJsApi::addJScript('updDynamicListeners', $js);
?>
<article class="productdetails-view vm-productdetails" itemscope itemtype="https://schema.org/Product">
	<div class="row">
		<div class="<?php echo $imageClass ?>">
			<?php echo $this->loadTemplate('imagegallery'); ?>
		</div>
		<div class="<?php echo $mainClass ?>">
			<div class="product-title-cont">
				<?php if ($template->showPageHeadingInBreadcrumbs() && $params->get('producttitle_in_breadcrumbs', 1)) : ?>
					<?php $template->setPageHeading($this->product->product_name); ?>
					<meta itemprop="name" content="<?php echo $this->product->product_name; ?>"/>
					<h2 class="product-title"><?php echo JText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></h2>
				<?php else : ?>
					<h1 class="product-title" itemprop="name"><?php echo $this->product->product_name ?></h1>
				<?php endif; ?>
				<?php echo $this->edit_link; ?>
				<?php echo $this->loadTemplate('icons') ?>
			</div>
			<?php if (!empty($this->product->event->afterDisplayTitle)) : ?>
				<div class="eventAfterDisplayTitle">
					<?php echo $this->product->event->afterDisplayTitle ?>
				</div>
			<?php endif; ?>
			<div class="product-rating-cont clearfix">
				<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $this->showRating, 'product' => $this->product, 'detailsPage' => true, 'reviewCountURL' => '#tab-reviews')); ?>
			</div>
			<div class="product-price-stock-sku-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $this->product, 'currency' => $this->currency, 'showDetails' => $params->get('vm_show_all_prices', 0))); ?>
				<div class="product-stock-sku-cont row row-condensed">
					<?php $show_stock = VmConfig::get('display_stock', 1); ?>
					<?php if ($show_stock) : ?>
						<div class="product-stock-cont col-sm-6">
							<?php $stock = VPFrameworkVM::getStockText($this->product); ?>
							<span class="<?php echo $stock->class ?> hasTooltip" title="<?php echo $stock->tip ?>"><?php echo $stock->text ?></span>
						</div>
					<?php endif; ?>
					<?php if ($params->get('show_vm_sku', 1) && !empty($this->product->product_sku)) : ?>
						<div class="product-sku-cont <?php echo $show_stock ? 'col-sm-6' : 'col-sm-12'; ?>">
							<?php echo JText::_('COM_VIRTUEMART_CART_SKU') . ': <span itemprop="sku">' . $this->product->product_sku  . '</span>'; ?>
						</div>
					<?php elseif (!empty($this->product->product_sku)) : ?>
						<meta itemprop="sku" content="<?php echo $this->product->product_sku; ?>" />
					<?php endif; ?>
				</div>
				<?php if (!empty($this->product->product_mpn)) : ?>
					<meta itemprop="mpn" content="<?php echo $this->product->product_mpn; ?>" />
				<?php endif; ?>
				<?php if (!empty($this->product->product_gtin)) : ?>
					<meta itemprop="gtin" content="<?php echo $this->product->product_gtin; ?>" />
				<?php endif; ?>
			</div>
			<?php if (!empty($this->product->product_s_desc)) : ?>
				<div class="product-short-desc-cont" <?php echo empty($metaDescription) ? ' itemprop="description"' : ''; ?>>
					<?php echo $this->product->product_s_desc ?>
				</div>
			<?php endif; ?>
			<?php if (!empty($this->product->customfieldsSorted['ontop'])) : ?>
				<div class="ontop-fields-cont">
					<?php echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $this->product, 'position' => 'ontop')); ?>
				</div>
			<?php endif; ?>
			<div class="product-addtocart-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $this->product, 'askquestion_url' => $askquestion_url)); ?>
			</div>
			<?php if (VmConfig::get('ask_question', 0) && !empty($this->product->show_separate_ask_question)) : ?>
				<div class="product-action-buttons-cont">
					<button type="button" class="btn btn-nobg" data-iframe="modal" data-modaltitle="<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ASK_QUESTION') ?>" title="<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ENQUIRY_LBL') ?>" data-url="<?php echo $askquestion_url ?>">
						<i class="fa fa-question"></i><span><?php echo JText::_('COM_VIRTUEMART_PRODUCT_ASK_QUESTION') ?></span>
					</button>
				</div>
			<?php endif; ?>
			<?php if ($params->get('vm_wishlist', 1) || $params->get('vm_compare', 1)) : ?>
				<div class="product-action-buttons-cont first-set">
					<?php if (defined ('VMESSENTIALS_ADMINISTRATOR') && $vmeParams->get('enable_wishlist', 1)) : ?>
						<?php echo JHtml::_('vmessentials.addtowishlist', $this->product, false); ?>
					<?php elseif ($params->get('vm_wishlist', 1)) : ?>
						<button type="button" class="vpf-addtowishlist-btn btn btn-nobg" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?>" data-productname="<?php echo htmlspecialchars($this->product->product_name, ENT_COMPAT, 'UTF-8'); ?>" data-productid="<?php echo $this->product->virtuemart_product_id ?>">
							<i class="fa fa-heart-o"></i><span><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?></span>
						</button>
					<?php endif; ?>
					<?php if (defined ('VMESSENTIALS_ADMINISTRATOR') && $vmeParams->get('enable_compare', 1)) : ?>
						<?php echo JHtml::_('vmessentials.addtocompare', $this->product, false); ?>
					<?php elseif ($params->get('vm_compare', 1)) : ?>
						<button type="button" class="vpf-addtocompare-btn btn btn-nobg" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?>" data-productname="<?php echo htmlspecialchars($this->product->product_name, ENT_COMPAT, 'UTF-8'); ?>" data-productid="<?php echo $this->product->virtuemart_product_id ?>">
							<i class="fa fa-copy"></i><span><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?></span>
						</button>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="product-action-buttons-cont">
				<?php if ($this->product->virtuemart_category_id) 
				{
					$catURL =  JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . (int) $this->product->virtuemart_category_id, false);
					$categoryName = '<span itemprop="category">' . $this->product->category_name . '</span>';
				} 
				else 
				{
					$catURL =  JRoute::_('index.php?option=com_virtuemart');
					$categoryName = vmText::_('COM_VIRTUEMART_SHOP_HOME') ;
				} ?>
				<a href="<?php echo $catURL ?>" class="btn btn-nobg hover-invert btn-backtocat" title="<?php echo strip_tags($categoryName) ?>"><?php echo vmText::sprintf('COM_VIRTUEMART_CATEGORY_BACK_TO', $categoryName) ?></a>
			</div>
			<?php if (!$showTopRight && $params->get('show_vm_social_buttons', 1) && empty($print)) : ?>
				<div class="product-action-buttons-cont">
					<?php echo $this->loadTemplate('addthis'); ?>
				</div>
			<?php endif; ?>
		</div>
		<?php if ($showTopRight) : ?>
			<div class="clearfix visible-xs visible-sm"></div>
			<div class="col-md-3 col-sm-12">
				<div class="product-top-right-cont">
					<?php if (VmConfig::get('show_manufacturers', 1) && !empty($this->product->virtuemart_manufacturer_id)) : ?>
						<?php echo $this->loadTemplate('manufacturer') ?>
					<?php endif; ?>
					<?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $this->product)); ?>
					<?php if (!empty($this->product->customfieldsSorted['top-right'])) : ?>
						<div class="top-right-fields">
							<?php echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $this->product, 'position' => 'top-right')); ?>
						</div>
					<?php endif; ?>
					<?php if (is_array($this->productDisplayShipments) && !empty($this->productDisplayShipments)) : ?>
						<div class="top-right-fields productDisplayShipments">
							<?php foreach($this->productDisplayShipments as $productDisplayShipment) : ?>
								<?php if (empty($productDisplayShipment)) continue; ?>
								<?php $productDisplayShipment = !is_array($productDisplayShipment) ? array($productDisplayShipment) : $productDisplayShipment; ?>
								<?php foreach($productDisplayShipment as $key => $productShipmentHtml) : ?>
									<div class="product-display-shipment product-display-shipment-<?php echo $key ?>">
										<?php echo $productShipmentHtml ?>
									</div>
								<?php endforeach; ?>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
					<?php if (is_array($this->productDisplayPayments) && !empty($this->productDisplayPayments)) : ?>
						<div class="top-right-fields productDisplayPayments">
							<?php foreach($this->productDisplayPayments as $productDisplayPayment) : ?>
								<?php if (empty($productDisplayPayment)) continue; ?>
								<?php $productDisplayPayment = !is_array($productDisplayPayment) ? array($productDisplayPayment) : $productDisplayPayment; ?>
								<?php foreach($productDisplayPayment as $key => $productDisplayHtml) : ?>
									<div class="product-display-payment product-display-payment-<?php echo $key ?>">
										<?php echo $productDisplayHtml ?>
									</div>
								<?php endforeach; ?>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
					<?php echo $this->loadTemplate('addthis'); ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
	<div class="row">
		<?php if (!empty($this->product->event->beforeDisplayContent)) : ?>
			<div class="eventBeforeDisplayContent clearfix">
				<div class="col-xs-12">
					<?php echo $this->product->event->beforeDisplayContent; ?>
				</div>
			</div>
		<?php endif; ?>
		
		<div class="col-xs-12">
			<div class="product-bottom-cont">
				<?php if (!empty($tabTitles) && !empty($tabDisplays)) : ?>
					<div class="product-tabpanel" role="tabpanel">
						<!-- Nav tabs -->
						<ul class="nav nav-list" role="tablist">
							<?php $i = 0; ?>
							<?php foreach($tabTitles as $id => $title) : ?>
								<?php $i++; ?>
								<li role="presentation"<?php echo ($i == 1) ? ' class="active"' : ''; ?>>
									<a href="#<?php echo $id ?>" aria-controls="<?php echo $id ?>" role="tab" data-toggle="tab"><?php echo $title ?></a>
								</li>
							<?php endforeach; ?>
							<?php if ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview) : ?>
								<li role="presentation">
									<a href="#tab-reviews" aria-controls="tab-reviews" role="tab" data-toggle="tab"><?php echo vmText::_('COM_VIRTUEMART_REVIEWS') ?></a>
								</li>
							<?php endif; ?>
						</ul>
						<!-- Tab panes -->
						<div class="tab-content with-list-tab">
							<?php $i = 0; ?>
							<?php foreach($tabDisplays as $id => $display) : ?>
								<?php $i++; ?>
								<div role="tabpanel" class="tab-pane fade<?php echo ($i == 1) ? ' in active' : ''; ?>" id="<?php echo $id ?>">
									<div <?php echo empty($metaDescription) && empty($this->product->product_s_desc) && !empty($this->product->product_desc) ? 'class="product-tab-texts" itemprop="description"' : 'class="product-tab-texts`"'; ?>>
										<?php echo $display ?>
									</div>
									<?php if ($i == 1 && $this->product->product_box) : ?>
										<div class="product-box">
											<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX') . $this->product->product_box; ?>
										</div>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>
							<?php if ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview) : ?>
								<div role="tabpanel" class="tab-pane fade" id="tab-reviews">
									<?php echo $this->loadTemplate('reviews'); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
        <?php elseif ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview) : ?>
          <div class="product-tabpanel" role="tabpanel">
            <!-- Nav tabs -->
            <ul class="nav nav-list" role="tablist">
							<li role="presentation" class="active">
								<a href="#tab-reviews" aria-controls="tab-reviews" role="tab" data-toggle="tab"><?php echo vmText::_('COM_VIRTUEMART_REVIEWS') ?></a>
							</li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content with-list-tab">
							<div role="tabpanel" class="tab-pane fade in active" id="tab-reviews">
								<?php echo $this->loadTemplate('reviews'); ?>
							</div>
            </div>
          </div>
				<?php endif; ?>
				<?php if (!empty($related['products'])) : ?>
					<?php $this->related_products = $related['products']; ?>
				<?php endif; ?>
				<?php echo $this->loadTemplate('relatedproducts'); ?>
			</div>
		</div>
		
		<?php if (!empty($this->product->event->afterDisplayContent)) : ?>
			<div class="eventAfterDisplayContent clearfix">
				<div class="col-xs-12">
					<?php echo $this->product->event->afterDisplayContent; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
	
	<?php if (!empty($this->product->customfieldsSorted['onbot'])) : ?>
		<div class="ontop-fields-cont">
			<?php echo shopfunctionsf::rendervmsublayout('customfields', array('product' => $this->product, 'position' => 'onbot')); ?>
		</div>
	<?php endif; ?>
	
	<?php if (!empty($related['categories'])) : ?>
		<?php $this->assignRef('related_categories', $related['categories']); ?>
		<?php echo $this->loadTemplate('relatedcategories'); ?>
	<?php endif; ?>

	<?php if (!empty($this->cat_productdetails) || (!isset($this->cat_productdetails) && VmConfig::get('showCategory', 1))) : ?>
		<?php echo $this->loadTemplate('showcategory'); ?>
	<?php endif; ?>
	
	<?php if (!empty($metaDescription)) : ?>
		<meta itemprop="description" content="<?php echo htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8'); ?>" />
	<?php endif; ?>
	
	<?php echo vmJsApi::writeJS(); ?>
	
</article>
<script type="text/javascript">
	Virtuemart.container = jQuery('.productdetails-view');
	Virtuemart.containerSelector = '.productdetails-view';
</script>