<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ( '_JEXEC' ) or die ('Restricted access');

$template     = plgSystemVPFrameworkHelper::getTemplate();
$min          = VmConfig::get('asks_minimum_comment_length', 50);
$max          = VmConfig::get('asks_maximum_comment_length', 2000);
$vendorModel  = VmModel::getModel ('vendor');
$this->vendor = $vendorModel->getVendor($this->product->virtuemart_vendor_id);

vmJsApi::JvalideForm();
vmJsApi::addJScript('askform','
    jQuery(function($){
        $("#askform").validationEngine("attach");
        var counterResult = $("#comment").val().length;
        $("#counter").val(counterResult);
        $("#comment").keyup( function () {
            var result = $(this).val();
            $("#counter").val( result.length );
        });
    });
');

if (empty($this->product )) 
{
	echo vmText::_ ( 'COM_VIRTUEMART_PRODUCT_NOT_FOUND' );
	echo '<br/>' . $this->continue_link_html;
} 
else 
{
	$mailRecommendData = array(
		'email' => '',
		'name' => '',
		'comment' => ''
	);
	$session = JFactory::getSession();
	$mailRecommendData = $session->get('mailrecommend', $mailRecommendData, 'vm');
	if(!empty($this->login)) : ?>
		<div class="ask-question-page-login">
			<?php echo $this->login; ?>
		</div>
	<?php endif;
	if(empty($this->login) || VmConfig::get('recommend_unauth', false)){ ?>
		<div class="ask-question-page">
			<div class="product-overview well">
				<div class="row">
					<div class="col-xs-8">
						<h5 class="product-name"><?php echo $this->product->product_name ?></h5>
						<?php if(!empty($this->product->product_s_desc)) : ?>
							<div class="short-description">
								<?php echo $this->product->product_s_desc ?>
							</div>
						<?php endif; ?>
					</div>
					<div class="col-xs-4">
						<div class="align-center">
							<?php echo $this->product->images[0]->displayMediaThumb('class="img-thumbnail"', false); ?>
						</div>
					</div>
				</div>
			</div>

			<form method="post" class="form-validate" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product->virtuemart_product_id.'&virtuemart_category_id='.$this->product->virtuemart_category_id.'&tmpl=component', FALSE) ; ?>" name="askform" id="askform">

				<div class="form-group">
					<label for="name"><?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_NAME') ?></label>
					<input type="text" class="form-control validate[required,minSize[3],maxSize[64]]" value="<?php echo $this->user->name ? $this->user->name : $mailRecommendData['name'] ?>" name="name" id="name" size="30" validation="required name" placeholder="<?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_NAME') ?>"/>
				</div>
				<div class="form-group">
					<label for="email"><?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_EMAIL') ?></label>
					<input type="text" class="form-control validate[required,custom[email]]" value="<?php echo $this->user->email ? $this->user->email : $mailRecommendData['email'] ?>" name="email" id="email" size="30" validation="required email" placeholder="<?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_EMAIL') ?>"/>
				</div>
				<div class="form-group">
					<label for="comment"><?php echo vmText::sprintf('COM_VIRTUEMART_COMMENT', $min, $max); ?></label>
					<textarea class="form-control validate[required,minSize[<?php echo $min ?>],maxSize[<?php echo $max ?>]] field" id="comment" name="comment" rows="4" placeholder="<?php echo vmText::sprintf('COM_VIRTUEMART_RECOMMEND_COMMENT', $this->vendor->vendor_store_name) ?>"><?php echo $mailRecommendData['comment'] ?></textarea>
				</div>
				<div class="form-group group-inline">
					<label for="counter" ><?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT') ?></label>
					<input type="text" value="0" size="4" class="form-control counter" id="counter" name="counter" maxlength="4" readonly="readonly" />
				</div>
				<?php if (VmConfig::get('ask_captcha')) : ?>
					<div class="form-group">
						<label for="captcha" class="sr-only"><?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT') ?></label>
						<?php echo $this->captcha; ?>
					</div>
				<?php endif; ?>
				<div class="form-submit-cont">
					<button type="submit" class="btn btn-base btn-lg" title="<?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_SUBMIT') ?>"><?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_SUBMIT') ?></button>
				</div>

				<input type="hidden" name="virtuemart_product_id" value="<?php echo vRequest::getInt('virtuemart_product_id',0); ?>" />
				<input type="hidden" name="tmpl" value="component" />
				<input type="hidden" name="view" value="productdetails" />
				<input type="hidden" name="option" value="com_virtuemart" />
				<input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>" />
				<input type="hidden" name="task" value="mailRecommend" />
				<?php echo JHTML::_( 'form.token' ); ?>
			</form>

		</div>
<?php
	}
} ?>