<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$_template        = plgSystemVPFrameworkHelper::getTemplate();
$_params          = $_template->params;
$product          = $viewData['product'];
$position         = $viewData['position'];
$isList           = isset($viewData['isList']) ? $viewData['isList'] : false;
$class            = isset($viewData['class']) ? $viewData['class'] : 'product-fields';
$customTitle      = isset($viewData['customTitle']) ? $viewData['customTitle'] : false;
$custom_title     = null;
$related_products = array();
?>
<?php if(!empty($product->customfieldsSorted[$position])) :  ?>
	<div class="<?php echo $class?>">
	
		<?php if($customTitle && isset($product->customfieldsSorted[$position][0])) : ?>
			<?php 
			$field = $product->customfieldsSorted[$position][0];
			$titleClass = (!empty($field->custom_tip) && !$isList) ? 'class="product-fields-title hasTooltip"' : 'class="product-fields-title"';
			$title = !empty($field->custom_tip) ? ' title="' . vmText::_($field->custom_tip) . '"' : '';
			?>
			<div class="product-fields-title-wrapper">
				<span <?php echo $titleClass . $title ?>><?php echo vmText::_($field->custom_title) ?></span>
			</div>
		<?php endif; ?>
		
		<?php $custom_title = null; ?>
		<?php foreach($product->customfieldsSorted[$position] as $field) : ?>
			<?php if(!$field->is_hidden && !in_array($field->field_type, array('R', 'Z')) && !empty($field->display)) : ?> 
				<div class="product-field product-field-type-<?php echo $field->field_type ?>">
					<?php if(!$customTitle && ($field->custom_title != $custom_title) && $field->show_title) : ?>
						<?php 
						$titleClass = (!empty($field->custom_tip) && !$isList) ? 'class="product-fields-title hasTooltip"' : 'class="product-fields-title"';
						$title = !empty($field->custom_tip) ? ' title="' . vmText::_($field->custom_tip) . '"' : '';
						?>
						<div class="product-fields-title-wrapper">
							<span <?php echo $titleClass . $title ?>><?php echo vmText::_($field->custom_title) ?></span>
						</div>
					<?php endif; ?>
					<?php if(!empty($field->display)) : ?>
						<div class="product-field-display">
							<?php
							if($field->is_cart_attribute)
							{
								if($field->field_type == 'S')
								{
									echo VPFrameworkVM::displayStringTypeField($field, $_params, $isList);
								}
								elseif(in_array($field->field_type, array('A', 'C')))
								{
									echo VPFrameworkVM::displayListTypeField($field, $_params, $isList);
								}
								else
								{
									echo $field->display;
								}
							}
							else
							{
								echo str_replace('vm-chzn-select', 'vm-field-selectpicker', $field->display);
							} 
							?>
						</div>
					<?php endif; ?>
					<?php if(!empty($field->custom_desc)) : ?>
						<div class="product-field-desc"><?php echo vmText::_($field->custom_desc) ?></div> 
					<?php endif; ?>
				</div>
				<?php $custom_title = $field->custom_title; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
<?php endif; ?>