<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die('Restricted access');

$params             = plgSystemVPFrameworkHelper::getTemplate()->params;
$product            = $viewData['product'];
$stockhandle        = VmConfig::get('stockhandle', 'none');
$costPrice          = (float) $product->prices['costPrice'];
$salesPrice         = (float) $product->prices['salesPrice'];
$tmpPrice           = !empty($costPrice) && !empty($salesPrice);
$showAddToCartHover = isset($viewData['showAddToCartHover']) ? $viewData['showAddToCartHover'] : ($params->get('vm_list_show_addtocart' , 1) == 2);
$tooltip            = isset($viewData['tooltip']) ? $viewData['tooltip'] : true;;
$class              = $tooltip ? 'btn btn-foricon hasTooltip' : 'btn btn-foricon';
$html               = array();
$vmeParams          = defined ('VMESSENTIALS_ADMINISTRATOR') ? JComponentHelper::getParams('com_vmessentials') : null;
$noAddToCart        = ($product->product_discontinued && $params->get('vm_handle_discontinued_products', 0)) ? true : false;

if ($showAddToCartHover && !$noAddToCart)
{
	$buttonText = JText::_('COM_VIRTUEMART_CART_ADD_TO');
	$icon       = 'fa-smart-cart-o';
	$isNotify   = false;
	
	if (VPFrameworkVM::hasCartAttribute($product))
	{
		$buttonText = JText::_('TPL_VP_SMART_VIEW_OPTIONS');
	}
	elseif ((property_exists($product, 'show_notify') && $product->show_notify) || (!property_exists($product, 'show_notify') && ($stockhandle == 'disableit' || $stockhandle == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1))
	{
		$buttonText = JText::_('COM_VIRTUEMART_CART_NOTIFY');
		$icon       = 'fa-comment-o';
		$isNotify   = true;
	}

	if ($isNotify || (!(VmConfig::get('askprice', true) && empty($tmpPrice))))
	{
		$html[] = '<button type="button" class="btn-hover-addtocart ' . $class . '" title="' . $buttonText . '">';
		$html[] = '<i class="fa ' . $icon . '"></i><span class="sr-only">' . $buttonText . '</span>';
		$html[] = '</button>';
	}
}

if (defined ('VMESSENTIALS_ADMINISTRATOR') && $vmeParams->get('enable_wishlist', 1))
{
	$html[] = JHtml::_('vmessentials.addtowishlist', $product, true);
}
elseif ($params->get('vm_wishlist', 1))
{
	$html[] = '<button type="button" class="vpf-addtowishlist-btn ' . $class . '" title="' . JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') . '" data-productid="' . $product->virtuemart_product_id . '" data-catid="' . $product->virtuemart_category_id . '" data-productname="' . htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8') . '">';
	$html[] = '<i class="fa fa-heart-o"></i><span class="sr-only">' . JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') . '</span>';
	$html[] = '</button>';
}

if (defined ('VMESSENTIALS_ADMINISTRATOR') && $vmeParams->get('enable_compare', 1))
{
	$html[] = JHtml::_('vmessentials.addtocompare', $product, true);
}
elseif ($params->get('vm_compare', 1))
{
	$html[] = '<button type="button" class="vpf-addtocompare-btn ' . $class . '" title="' . JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') . '" data-productid="' . $product->virtuemart_product_id . '" data-catid="' . $product->virtuemart_category_id . '" data-productname="' . htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8') . '">';
	$html[] = '<i class="fa fa-copy"></i><span class="sr-only">' . JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') . '</span>';
	$html[] = '</button>';
}

if ($params->get('vm_quickview', 1))
{
	$html[] = '<button type="button" class="vpf-quickview-btn ' . $class . '" title="' . JText::_('PLG_SYSTEM_VPFRAMEWORK_QUICKVIEW_LABEL') . '" data-productid="' . $product->virtuemart_product_id . '" data-catid="' . $product->virtuemart_category_id . '" data-productname="' . htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8') . '">';
	$html[] = '<i class="fa fa-smart-search"></i><span class="sr-only">' . JText::_('PLG_SYSTEM_VPFRAMEWORK_QUICKVIEW_LABEL') . '</span>';
	$html[] = '</button>';
}
?>
<?php if (!empty($html)) : ?>
	<div class="product-action-buttons display-on-mouseover" data-animate="fadeInUp animated-faster">
		<?php echo VPFrameworkUtility::sanitizeOutput(implode($html)); ?>
	</div>
<?php endif; ?>