<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$_template          = plgSystemVPFrameworkHelper::getTemplate();
$params             = $_template->params;
$productModel       = VmModel::getModel('product');
$products           = $viewData['products'];
$currency           = $viewData['currency'];
$showRating         = isset($viewData['showRating']) ? $viewData['showRating'] : 1;
$showRating         = $showRating && $params->get('vm_list_show_rating' , 1);
$showAddToCart      = isset($viewData['showAddToCart']) ? $viewData['showAddToCart'] : $params->get('vm_list_show_addtocart' , 1);
$showAddToCartHover = $showAddToCart && ($params->get('vm_list_show_addtocart' , 1) == 2);
$showPrice          = isset($viewData['showPrice']) ? $viewData['showPrice'] : 1;
$class              = 'product-listing mode-list';
$isCategoryView     = isset($viewData['isCategoryView']) ? $viewData['isCategoryView'] : true;
$Itemid             = null;

if ($isCategoryView)
{
	$Itemid = method_exists('shopFunctionsF', 'getLastVisitedItemId') ? shopFunctionsF::getLastVisitedItemId() : null;
}

if($_template->params->get('vm_image_product_lazyload', 0))
{
	$class .= ' lazyload-enabled';
}
?>
<div class="<?php echo $class ?>">
	<?php if(!empty($products)) : ?>
		<?php if($params->get('mouse_over_image_change', 1) && VmConfig::get('prodimg_browse', 1) < 2)
		{
			$productModel->addImages($products, 2);
		} ?>
		<div class="row row-condensed">
		<?php foreach($products as $product) : ?>
			<?php
			$productLink = empty($product->link) ? $product->canonical : $product->link;
			$pItemid     = !$Itemid ? VPFrameworkVM::getMenuId($productLink) : $Itemid;
			$ItemidStr   = !empty($pItemid) ? '&Itemid=' . $pItemid : '';
			$productLink = JRoute::_($productLink . $ItemidStr);
			?>
			<div class="product product-item col-xs-12">
				<div class="product-inner">
					<div class="row row-condensed">
						<div class="col-xs-5 col-sm-5 col-md-5 col-lg-4">
							<div class="product-image-cont">
								<a href="<?php echo $productLink; ?>">
									<?php echo shopFunctionsF::renderVmSubLayout('tags', array('product' => $product)); ?>
									<?php if($params->get('mouse_over_image_change') && isset($product->images[1])) : ?>
										<?php if($params->get('vm_image_product_lazyload', 0))
										{
											echo VPFrameworkVM::displayThumnbailLazily($product->images[0], $product->product_name, 'container-fit-image start-image load-lazily');
											echo '<div class="on-mouseover-image">';
											echo VPFrameworkVM::displayThumnbailLazily($product->images[1], $product->product_name, 'container-fit-image load-lazily');
											echo '</div>';
										}
										else
										{
											echo $product->images[0]->displayMediaThumb('class="responsive-image start-image"', false);
											echo '<div class="on-mouseover-image">';
											echo $product->images[1]->displayMediaThumb('class="responsive-image"', false);
											echo '</div>';
										} ?>
									<?php else : ?>
										<?php if($params->get('vm_image_product_lazyload', 0))
										{
											echo VPFrameworkVM::displayThumnbailLazily($product->images[0], $product->product_name, 'container-fit-image display-always-image load-lazily');
										}
										else
										{
											echo $product->images[0]->displayMediaThumb('class="responsive-image display-always-image"', false);
										} ?>
									<?php endif; ?>
								</a>
								<?php echo shopFunctionsF::renderVmSubLayout('productextras', array('product' => $product, 'showAddToCartHover' => $showAddToCartHover)); ?>
							</div>
						</div>
						<div class="col-xs-7 col-sm-7 col-md-7 col-lg-8">
							<div class="list-mode-right-cont">
								<div class="product-name-cont">
									<h3 class="product-name">
										<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
									</h3>
								</div>
								<?php if($params->get('show_vm_list_category_name', 1) && !empty($product->category_name)) : ?>
									<div class="product-cat-name-cont">
										<span class="text-muted category-name"><?php echo $product->category_name; ?></span>
									</div>
								<?php endif; ?>
								<?php if($showRating) : ?>
									<div class="product-rating-cont">
										<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $showRating, 'product' => $product, 'addSchema' => false)); ?>
									</div>
								<?php endif; ?>
								<?php if($showPrice) : ?>
									<div class="product-price-cont">
										<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency, 'addSchema' => false)); ?>
									</div>
								<?php endif; ?>
								<?php if(!empty($product->product_s_desc)) : ?>
								<div class="product-short-desc-cont hidden-xs">
									<?php echo $product->product_s_desc ?>
								</div>
								<?php endif; ?>
								<?php if($showAddToCart && $product->prices['salesPrice'] > 0) : ?>
									<?php if($params->get('vm_list_show_addtocart' , 1) == 1) : ?>
										<div class="product-addtocart-cont">
											<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => true, 'listMode' => 'list', 'showDetailsLink' => true)); ?>
										</div>
									<?php else : ?>
										<div class="product-addtocart-cont hide">
											<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => true, 'listMode' => 'list', 'showDetailsLink' => false)); ?>
										</div>
										<div class="product-addtocart-cont">
											<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="btn btn-primary btn-md hidden-xs"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></a>
										</div>
									<?php endif; ?>
								<?php else : ?>
									<div class="product-addtocart-cont">
										<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="btn btn-primary btn-md hidden-xs"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS') ?></a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>