<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$product          = $viewData['product'];
$showRating       = isset($viewData['showRating']) ? $viewData['showRating'] : false;
$detailsPage      = isset($viewData['detailsPage']) ? $viewData['detailsPage'] : false;
$reviewCountURL   = isset($viewData['reviewCountURL']) ? $viewData['reviewCountURL'] : false;
$addSchema        = isset($viewData['addSchema']) ? $viewData['addSchema'] : true;
$template         = plgSystemVPFrameworkHelper::getTemplate();
$maxrating        = VmConfig::get('vm_maximum_rating_scale', 5);
$hint             = array();

for($i=1; $i<=$maxrating; $i++)
{
	$hint[] = "'" . $i . " " . vmText::_('COM_VIRTUEMART_REVIEW_STARS') . "'";
}

$hint   = '[' . implode(',', $hint) . ']';
$rateJS = "
jQuery(document).ready(function($) {
	$(document).on('vpf.rating.updated', function() {
		$('.vm-product-rating').raty({
		score: function() {
			return $(this).data('score') ? $(this).data('score') : 0;
		},
		numberMax: " . $maxrating . ",
		number: " . $maxrating . ",
		hints: " . $hint . ",
		starType: 'i',
		halfShow: true,
		readOnly: true,
		noRatedMsg: '" . vmText::_('COM_VIRTUEMART_UNRATED') . "'
		});
	});
	$(document).trigger('vpf.rating.updated');
});
";
vmJsApi::addJScript('productRating', $rateJS);
if($showRating) :
	$rating = VPFrameworkVM::getRating($product->virtuemart_product_id);
	$score = round($rating->rating, 0);
	$title = (empty($rating->count) || $rating->count == 1) ? JText::_('PLG_SYSTEM_VPFRAMEWORK_RATING') : JText::_('PLG_SYSTEM_VPFRAMEWORK_RATINGS'); 
	if($detailsPage)
	{
		$reviewCount = VPFrameworkVM::getReviewCount($product->virtuemart_product_id);
		$reviewTitle = ($reviewCount == 1) ? vmText::_('COM_VIRTUEMART_REVIEW') : vmText::_('COM_VIRTUEMART_REVIEWS');
	}
	$schema = ($addSchema && $score > 1) ? ' itemprop="aggregateRating" itemscope="" itemtype="https://schema.org/AggregateRating"' : '';
	?>
	<?php if($score > 1 || $detailsPage) : ?>
		<div class="product-rating"<?php echo $schema ?>>
			<?php if($addSchema && $score > 1) : ?>
				<meta itemprop="ratingValue" content="<?php echo $score ?>"/>
				<meta itemprop="bestRating" content="<?php echo $maxrating ?>"/>
				<meta itemprop="worstRating" content="1"/>
				<meta itemprop="ratingCount" content="<?php echo $rating->count ?>"/>
			<?php endif; ?>
			<span class="rating">
				<span class="vm-product-rating" data-score="<?php echo $score ?>"></span>
				<?php if($detailsPage) : ?>
					<span class="text-muted"><?php echo $rating->count ?></span>
					<span class="text-muted rating-suffix"><?php echo $title; ?></span>
				<?php endif; ?>
			</span>
			<?php if($detailsPage && !empty($reviewCount)) : ?>
				<?php if($addSchema && $score > 1) : ?>
					<meta itemprop="reviewCount" content="<?php echo $reviewCount ?>"/>
				<?php endif; ?>
				<?php if($reviewCountURL) : ?>
					<a href="<?php echo $reviewCountURL ?>" class="show-product-reviews">
						<span><?php echo $reviewCount ?></span>
						<span class="review-suffix"><?php echo $reviewTitle; ?></span>
					</a>
				<?php else : ?>
					<span><?php echo $reviewCount ?></span>
					<span class="review-suffix"><?php echo $reviewTitle; ?></span>
				<?php endif; ?>
			<?php endif; ?>
		</div>
	<?php endif; ?>
<?php endif; ?>
