<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$ratingModel = VmModel::getModel('ratings');
$_template   = plgSystemVPFrameworkHelper::getTemplate();
$params      = $_template->params;
$related     = $viewData['related'];
$customfield = $viewData['customfield'];
$thumb       = $viewData['thumb'];
$currency    = calculationHelper::getInstance()->_currencyDisplay;
$uri         = 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $related->virtuemart_product_id . '&virtuemart_category_id=' . $related->virtuemart_category_id;
$productLink = empty($product->link) ? (empty($product->canonical) ? $uri : $product->canonical) : $product->link;
$Itemid      = VPFrameworkVM::getMenuId($productLink);
$ItemidStr   = !empty($Itemid) ? '&Itemid=' . $Itemid : '';
$url         = JRoute::_($productLink . $ItemidStr);
?>
<div class="related-item-cont">
	<div class="related-item-inner" itemprop="isRelatedTo" itemscope itemtype="https://schema.org/Product">
		<div class="related-item-image-cont">
			<a href="<?php echo $url ?>" title="<?php echo $related->product_name ?>"><?php echo str_replace('<img', '<img itemprop="image"', $thumb); ?></a>
		</div>
		<div class="related-item-name-cont">
			<h4 class="product-name">
				<a class="hover-invert" href="<?php echo $url ?>" title="<?php echo $related->product_name ?>" itemprop="url">
					<span itemprop="name"><?php echo $related->product_name ?></span>
				</a>
			</h4>
		</div>
		<?php if($params->get('show_vm_list_category_name', 1) && !empty($related->category_name)) : ?>
			<div class="related-cat-name-cont">
				<span itemprop="category" class="text-muted category-name"><?php echo $related->category_name; ?></span>
			</div>
		<?php endif; ?>
		<?php if($ratingModel->showRating($related->virtuemart_product_id) && $params->get('vm_list_show_rating' , 1)) : ?>
			<div class="product-rating-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => true, 'product' => $related, 'addSchema' => true)); ?>
			</div>
		<?php endif; ?>
		<?php if($customfield->wPrice) : ?>
			<div class="related-item-price-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $related, 'currency' => $currency)); ?>
			</div>
		<?php endif; ?>
		<?php if($customfield->wDescr && !empty($related->product_s_desc)) : ?>
			<div class="related-item-short-desc-cont">
				<p><?php echo $related->product_s_desc ?></p>
			</div>
		<?php endif; ?>
		<?php if(!empty($related->product_s_desc)) : ?>
			<meta itemprop="description" content="<?php echo htmlspecialchars(strip_tags($related->product_s_desc)); ?>"/>
		<?php elseif(!empty($related->product_desc)) : ?>
			<meta itemprop="description" content="<?php echo htmlspecialchars(strip_tags($related->product_desc)); ?>"/>
		<?php endif; ?>
		<?php if(!empty($related->product_sku)) : ?>
			<meta itemprop="sku" content="<?php echo htmlspecialchars($related->product_sku); ?>"/>
		<?php endif; ?>
		<?php if(!empty($related->product_mpn)) : ?>
			<meta itemprop="mpn" content="<?php echo htmlspecialchars($related->product_mpn); ?>"/>
		<?php endif; ?>
		<?php if(!empty($related->product_gtin)) : ?>
			<meta itemprop="gtin" content="<?php echo htmlspecialchars($related->product_gtin); ?>"/>
		<?php endif; ?>
		<?php if(VmConfig::get('show_manufacturers', 1) && !empty($related->mf_name)) : ?>
			<span itemprop="brand" itemtype="https://schema.org/Brand" itemscope>
				<meta itemprop="name" content="<?php echo htmlspecialchars($related->mf_name); ?>" />
			</span>
		<?php endif; ?>
	</div>
</div>