<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die('Restricted access');

JLoader::register('CurrencyDisplay', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/currencydisplay.php');

$product      = $viewData['product'];
$params       = plgSystemVPFrameworkHelper::getTemplate()->params;
$days         = (int) $params->get('vm_new_tag_days', 10);
$date         = JFactory::getDate('now - ' . $days . ' days');
$aDate        = JFactory::getDate($product->product_available_date);
$stockHandler = VmConfig::get('stockhandle_products', false) && property_exists($product, 'product_stockhandle') && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$currency     = CurrencyDisplay::getInstance();
$discount     = round($product->prices['discountAmount'], $currency->_priceConfig['salesPrice'][1]);
$tags         = '';

if($params->get('vm_show_sold_tag', 0) && ($stockHandler == 'disableit' || $stockHandler == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1)
{
	$tags .= '<span class="product-tag-left"><span class="tag tag-sold">' . JText::_($params->get('vm_sold_tag_text', 'Sold')) . '</span></span>';
}
elseif($params->get('vm_show_new_tag', 0) && ($aDate->toUnix() > 0) && ($aDate >= $date))
{
	$tags .= '<span class="product-tag-left"><span class="tag tag-new">' . JText::_($params->get('vm_new_tag_text', 'New')) . '</span></span>';
}
if($params->get('vm_show_discontinued_tag', 0) && $product->product_discontinued)
{
	$tags .= '<span class="product-tag-right"><span class="tag tag-discontinued">' . JText::_($params->get('vm_discontinued_tag_text', 'Discontinued')) . '</span></span>';
}
elseif($params->get('vm_show_promo_tag', 0) && $product->product_special)
{
	$tags .= '<span class="product-tag-right"><span class="tag tag-promo">' . JText::_($params->get('vm_promo_tag_text', 'Promo')) . '</span></span>';
}
elseif($params->get('vm_show_sale_tag', 0) && isset($product->prices) && !empty($discount))
{
	$tags .= '<span class="product-tag-right"><span class="tag tag-sale">' . JText::_($params->get('vm_sale_tag_text', 'Sale')) . '</span></span>';
}

echo $tags;